/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AccountFlags implements XdrElement
{
    AUTH_REQUIRED_FLAG(1),
    AUTH_REVOCABLE_FLAG(2),
    AUTH_IMMUTABLE_FLAG(4),
    AUTH_CLAWBACK_ENABLED_FLAG(8);

    private final int value;

    private AccountFlags(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountFlags decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return AUTH_REQUIRED_FLAG;
            }
            case 2: {
                return AUTH_REVOCABLE_FLAG;
            }
            case 4: {
                return AUTH_IMMUTABLE_FLAG;
            }
            case 8: {
                return AUTH_CLAWBACK_ENABLED_FLAG;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static AccountFlags fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountFlags.fromXdrByteArray(bytes);
    }

    public static AccountFlags fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountFlags.decode(xdrDataInputStream);
    }
}

