/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.ParallelTxExecutionStage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ParallelTxsComponent
implements XdrElement {
    private Int64 baseFee;
    private ParallelTxExecutionStage[] executionStages;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        if (this.baseFee != null) {
            stream.writeInt(1);
            this.baseFee.encode(stream);
        } else {
            stream.writeInt(0);
        }
        int executionStagesSize = this.getExecutionStages().length;
        stream.writeInt(executionStagesSize);
        for (int i = 0; i < executionStagesSize; ++i) {
            this.executionStages[i].encode(stream);
        }
    }

    public static ParallelTxsComponent decode(XdrDataInputStream stream) throws IOException {
        ParallelTxsComponent decodedParallelTxsComponent = new ParallelTxsComponent();
        int baseFeePresent = stream.readInt();
        if (baseFeePresent != 0) {
            decodedParallelTxsComponent.baseFee = Int64.decode(stream);
        }
        int executionStagesSize = stream.readInt();
        decodedParallelTxsComponent.executionStages = new ParallelTxExecutionStage[executionStagesSize];
        for (int i = 0; i < executionStagesSize; ++i) {
            decodedParallelTxsComponent.executionStages[i] = ParallelTxExecutionStage.decode(stream);
        }
        return decodedParallelTxsComponent;
    }

    public static ParallelTxsComponent fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ParallelTxsComponent.fromXdrByteArray(bytes);
    }

    public static ParallelTxsComponent fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ParallelTxsComponent.decode(xdrDataInputStream);
    }

    @Generated
    public static ParallelTxsComponentBuilder builder() {
        return new ParallelTxsComponentBuilder();
    }

    @Generated
    public ParallelTxsComponentBuilder toBuilder() {
        return new ParallelTxsComponentBuilder().baseFee(this.baseFee).executionStages(this.executionStages);
    }

    @Generated
    public Int64 getBaseFee() {
        return this.baseFee;
    }

    @Generated
    public ParallelTxExecutionStage[] getExecutionStages() {
        return this.executionStages;
    }

    @Generated
    public void setBaseFee(Int64 baseFee) {
        this.baseFee = baseFee;
    }

    @Generated
    public void setExecutionStages(ParallelTxExecutionStage[] executionStages) {
        this.executionStages = executionStages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParallelTxsComponent)) {
            return false;
        }
        ParallelTxsComponent other = (ParallelTxsComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Int64 this$baseFee = this.getBaseFee();
        Int64 other$baseFee = other.getBaseFee();
        if (this$baseFee == null ? other$baseFee != null : !((Object)this$baseFee).equals(other$baseFee)) {
            return false;
        }
        return Arrays.deepEquals(this.getExecutionStages(), other.getExecutionStages());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParallelTxsComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Int64 $baseFee = this.getBaseFee();
        result = result * 59 + ($baseFee == null ? 43 : ((Object)$baseFee).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getExecutionStages());
        return result;
    }

    @Generated
    public String toString() {
        return "ParallelTxsComponent(baseFee=" + this.getBaseFee() + ", executionStages=" + Arrays.deepToString(this.getExecutionStages()) + ")";
    }

    @Generated
    public ParallelTxsComponent() {
    }

    @Generated
    public ParallelTxsComponent(Int64 baseFee, ParallelTxExecutionStage[] executionStages) {
        this.baseFee = baseFee;
        this.executionStages = executionStages;
    }

    @Generated
    public static class ParallelTxsComponentBuilder {
        @Generated
        private Int64 baseFee;
        @Generated
        private ParallelTxExecutionStage[] executionStages;

        @Generated
        ParallelTxsComponentBuilder() {
        }

        @Generated
        public ParallelTxsComponentBuilder baseFee(Int64 baseFee) {
            this.baseFee = baseFee;
            return this;
        }

        @Generated
        public ParallelTxsComponentBuilder executionStages(ParallelTxExecutionStage[] executionStages) {
            this.executionStages = executionStages;
            return this;
        }

        @Generated
        public ParallelTxsComponent build() {
            return new ParallelTxsComponent(this.baseFee, this.executionStages);
        }

        @Generated
        public String toString() {
            return "ParallelTxsComponent.ParallelTxsComponentBuilder(baseFee=" + this.baseFee + ", executionStages=" + Arrays.deepToString(this.executionStages) + ")";
        }
    }
}

