/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimAtom;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveResultCode;
import org.stellar.sdk.xdr.SimplePaymentResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PathPaymentStrictReceiveResult
implements XdrElement {
    private PathPaymentStrictReceiveResultCode discriminant;
    private PathPaymentStrictReceiveResultSuccess success;
    private Asset noIssuer;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case PATH_PAYMENT_STRICT_RECEIVE_SUCCESS: {
                this.success.encode(stream);
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE_MALFORMED: 
            case PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED: 
            case PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST: 
            case PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION: 
            case PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST: 
            case PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL: {
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER: {
                this.noIssuer.encode(stream);
                break;
            }
        }
    }

    public static PathPaymentStrictReceiveResult decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictReceiveResult decodedPathPaymentStrictReceiveResult = new PathPaymentStrictReceiveResult();
        PathPaymentStrictReceiveResultCode discriminant = PathPaymentStrictReceiveResultCode.decode(stream);
        decodedPathPaymentStrictReceiveResult.setDiscriminant(discriminant);
        switch (decodedPathPaymentStrictReceiveResult.getDiscriminant()) {
            case PATH_PAYMENT_STRICT_RECEIVE_SUCCESS: {
                decodedPathPaymentStrictReceiveResult.success = PathPaymentStrictReceiveResultSuccess.decode(stream);
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE_MALFORMED: 
            case PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED: 
            case PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST: 
            case PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION: 
            case PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST: 
            case PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL: {
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER: {
                decodedPathPaymentStrictReceiveResult.noIssuer = Asset.decode(stream);
                break;
            }
        }
        return decodedPathPaymentStrictReceiveResult;
    }

    public static PathPaymentStrictReceiveResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictReceiveResult.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictReceiveResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictReceiveResult.decode(xdrDataInputStream);
    }

    @Generated
    public static PathPaymentStrictReceiveResultBuilder builder() {
        return new PathPaymentStrictReceiveResultBuilder();
    }

    @Generated
    public PathPaymentStrictReceiveResultBuilder toBuilder() {
        return new PathPaymentStrictReceiveResultBuilder().discriminant(this.discriminant).success(this.success).noIssuer(this.noIssuer);
    }

    @Generated
    public PathPaymentStrictReceiveResultCode getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public PathPaymentStrictReceiveResultSuccess getSuccess() {
        return this.success;
    }

    @Generated
    public Asset getNoIssuer() {
        return this.noIssuer;
    }

    @Generated
    public void setDiscriminant(PathPaymentStrictReceiveResultCode discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setSuccess(PathPaymentStrictReceiveResultSuccess success) {
        this.success = success;
    }

    @Generated
    public void setNoIssuer(Asset noIssuer) {
        this.noIssuer = noIssuer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictReceiveResult)) {
            return false;
        }
        PathPaymentStrictReceiveResult other = (PathPaymentStrictReceiveResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PathPaymentStrictReceiveResultCode this$discriminant = this.getDiscriminant();
        PathPaymentStrictReceiveResultCode other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        PathPaymentStrictReceiveResultSuccess this$success = this.getSuccess();
        PathPaymentStrictReceiveResultSuccess other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Asset this$noIssuer = this.getNoIssuer();
        Asset other$noIssuer = other.getNoIssuer();
        return !(this$noIssuer == null ? other$noIssuer != null : !((Object)this$noIssuer).equals(other$noIssuer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictReceiveResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PathPaymentStrictReceiveResultCode $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        PathPaymentStrictReceiveResultSuccess $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Asset $noIssuer = this.getNoIssuer();
        result = result * 59 + ($noIssuer == null ? 43 : ((Object)$noIssuer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PathPaymentStrictReceiveResult(discriminant=" + this.getDiscriminant() + ", success=" + this.getSuccess() + ", noIssuer=" + this.getNoIssuer() + ")";
    }

    @Generated
    public PathPaymentStrictReceiveResult() {
    }

    @Generated
    public PathPaymentStrictReceiveResult(PathPaymentStrictReceiveResultCode discriminant, PathPaymentStrictReceiveResultSuccess success, Asset noIssuer) {
        this.discriminant = discriminant;
        this.success = success;
        this.noIssuer = noIssuer;
    }

    @Generated
    public static class PathPaymentStrictReceiveResultBuilder {
        @Generated
        private PathPaymentStrictReceiveResultCode discriminant;
        @Generated
        private PathPaymentStrictReceiveResultSuccess success;
        @Generated
        private Asset noIssuer;

        @Generated
        PathPaymentStrictReceiveResultBuilder() {
        }

        @Generated
        public PathPaymentStrictReceiveResultBuilder discriminant(PathPaymentStrictReceiveResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveResultBuilder success(PathPaymentStrictReceiveResultSuccess success) {
            this.success = success;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveResultBuilder noIssuer(Asset noIssuer) {
            this.noIssuer = noIssuer;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveResult build() {
            return new PathPaymentStrictReceiveResult(this.discriminant, this.success, this.noIssuer);
        }

        @Generated
        public String toString() {
            return "PathPaymentStrictReceiveResult.PathPaymentStrictReceiveResultBuilder(discriminant=" + this.discriminant + ", success=" + this.success + ", noIssuer=" + this.noIssuer + ")";
        }
    }

    public static class PathPaymentStrictReceiveResultSuccess
    implements XdrElement {
        private ClaimAtom[] offers;
        private SimplePaymentResult last;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            int offersSize = this.getOffers().length;
            stream.writeInt(offersSize);
            for (int i = 0; i < offersSize; ++i) {
                this.offers[i].encode(stream);
            }
            this.last.encode(stream);
        }

        public static PathPaymentStrictReceiveResultSuccess decode(XdrDataInputStream stream) throws IOException {
            PathPaymentStrictReceiveResultSuccess decodedPathPaymentStrictReceiveResultSuccess = new PathPaymentStrictReceiveResultSuccess();
            int offersSize = stream.readInt();
            decodedPathPaymentStrictReceiveResultSuccess.offers = new ClaimAtom[offersSize];
            for (int i = 0; i < offersSize; ++i) {
                decodedPathPaymentStrictReceiveResultSuccess.offers[i] = ClaimAtom.decode(stream);
            }
            decodedPathPaymentStrictReceiveResultSuccess.last = SimplePaymentResult.decode(stream);
            return decodedPathPaymentStrictReceiveResultSuccess;
        }

        public static PathPaymentStrictReceiveResultSuccess fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return PathPaymentStrictReceiveResultSuccess.fromXdrByteArray(bytes);
        }

        public static PathPaymentStrictReceiveResultSuccess fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return PathPaymentStrictReceiveResultSuccess.decode(xdrDataInputStream);
        }

        @Generated
        public static PathPaymentStrictReceiveResultSuccessBuilder builder() {
            return new PathPaymentStrictReceiveResultSuccessBuilder();
        }

        @Generated
        public PathPaymentStrictReceiveResultSuccessBuilder toBuilder() {
            return new PathPaymentStrictReceiveResultSuccessBuilder().offers(this.offers).last(this.last);
        }

        @Generated
        public ClaimAtom[] getOffers() {
            return this.offers;
        }

        @Generated
        public SimplePaymentResult getLast() {
            return this.last;
        }

        @Generated
        public void setOffers(ClaimAtom[] offers) {
            this.offers = offers;
        }

        @Generated
        public void setLast(SimplePaymentResult last) {
            this.last = last;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathPaymentStrictReceiveResultSuccess)) {
                return false;
            }
            PathPaymentStrictReceiveResultSuccess other = (PathPaymentStrictReceiveResultSuccess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getOffers(), other.getOffers())) {
                return false;
            }
            SimplePaymentResult this$last = this.getLast();
            SimplePaymentResult other$last = other.getLast();
            return !(this$last == null ? other$last != null : !((Object)this$last).equals(other$last));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PathPaymentStrictReceiveResultSuccess;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getOffers());
            SimplePaymentResult $last = this.getLast();
            result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PathPaymentStrictReceiveResult.PathPaymentStrictReceiveResultSuccess(offers=" + Arrays.deepToString(this.getOffers()) + ", last=" + this.getLast() + ")";
        }

        @Generated
        public PathPaymentStrictReceiveResultSuccess() {
        }

        @Generated
        public PathPaymentStrictReceiveResultSuccess(ClaimAtom[] offers, SimplePaymentResult last) {
            this.offers = offers;
            this.last = last;
        }

        @Generated
        public static class PathPaymentStrictReceiveResultSuccessBuilder {
            @Generated
            private ClaimAtom[] offers;
            @Generated
            private SimplePaymentResult last;

            @Generated
            PathPaymentStrictReceiveResultSuccessBuilder() {
            }

            @Generated
            public PathPaymentStrictReceiveResultSuccessBuilder offers(ClaimAtom[] offers) {
                this.offers = offers;
                return this;
            }

            @Generated
            public PathPaymentStrictReceiveResultSuccessBuilder last(SimplePaymentResult last) {
                this.last = last;
                return this;
            }

            @Generated
            public PathPaymentStrictReceiveResultSuccess build() {
                return new PathPaymentStrictReceiveResultSuccess(this.offers, this.last);
            }

            @Generated
            public String toString() {
                return "PathPaymentStrictReceiveResult.PathPaymentStrictReceiveResultSuccess.PathPaymentStrictReceiveResultSuccessBuilder(offers=" + Arrays.deepToString(this.offers) + ", last=" + this.last + ")";
            }
        }
    }
}

