/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum PreconditionType implements XdrElement
{
    PRECOND_NONE(0),
    PRECOND_TIME(1),
    PRECOND_V2(2);

    private final int value;

    private PreconditionType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static PreconditionType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return PRECOND_NONE;
            }
            case 1: {
                return PRECOND_TIME;
            }
            case 2: {
                return PRECOND_V2;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static PreconditionType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PreconditionType.fromXdrByteArray(bytes);
    }

    public static PreconditionType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PreconditionType.decode(xdrDataInputStream);
    }
}

