/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanAddressCredentials
implements XdrElement {
    private SCAddress address;
    private Int64 nonce;
    private Uint32 signatureExpirationLedger;
    private SCVal signature;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.address.encode(stream);
        this.nonce.encode(stream);
        this.signatureExpirationLedger.encode(stream);
        this.signature.encode(stream);
    }

    public static SorobanAddressCredentials decode(XdrDataInputStream stream) throws IOException {
        SorobanAddressCredentials decodedSorobanAddressCredentials = new SorobanAddressCredentials();
        decodedSorobanAddressCredentials.address = SCAddress.decode(stream);
        decodedSorobanAddressCredentials.nonce = Int64.decode(stream);
        decodedSorobanAddressCredentials.signatureExpirationLedger = Uint32.decode(stream);
        decodedSorobanAddressCredentials.signature = SCVal.decode(stream);
        return decodedSorobanAddressCredentials;
    }

    public static SorobanAddressCredentials fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanAddressCredentials.fromXdrByteArray(bytes);
    }

    public static SorobanAddressCredentials fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanAddressCredentials.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanAddressCredentialsBuilder builder() {
        return new SorobanAddressCredentialsBuilder();
    }

    @Generated
    public SorobanAddressCredentialsBuilder toBuilder() {
        return new SorobanAddressCredentialsBuilder().address(this.address).nonce(this.nonce).signatureExpirationLedger(this.signatureExpirationLedger).signature(this.signature);
    }

    @Generated
    public SCAddress getAddress() {
        return this.address;
    }

    @Generated
    public Int64 getNonce() {
        return this.nonce;
    }

    @Generated
    public Uint32 getSignatureExpirationLedger() {
        return this.signatureExpirationLedger;
    }

    @Generated
    public SCVal getSignature() {
        return this.signature;
    }

    @Generated
    public void setAddress(SCAddress address) {
        this.address = address;
    }

    @Generated
    public void setNonce(Int64 nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setSignatureExpirationLedger(Uint32 signatureExpirationLedger) {
        this.signatureExpirationLedger = signatureExpirationLedger;
    }

    @Generated
    public void setSignature(SCVal signature) {
        this.signature = signature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanAddressCredentials)) {
            return false;
        }
        SorobanAddressCredentials other = (SorobanAddressCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCAddress this$address = this.getAddress();
        SCAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Int64 this$nonce = this.getNonce();
        Int64 other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Uint32 this$signatureExpirationLedger = this.getSignatureExpirationLedger();
        Uint32 other$signatureExpirationLedger = other.getSignatureExpirationLedger();
        if (this$signatureExpirationLedger == null ? other$signatureExpirationLedger != null : !((Object)this$signatureExpirationLedger).equals(other$signatureExpirationLedger)) {
            return false;
        }
        SCVal this$signature = this.getSignature();
        SCVal other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanAddressCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Int64 $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Uint32 $signatureExpirationLedger = this.getSignatureExpirationLedger();
        result = result * 59 + ($signatureExpirationLedger == null ? 43 : ((Object)$signatureExpirationLedger).hashCode());
        SCVal $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanAddressCredentials(address=" + this.getAddress() + ", nonce=" + this.getNonce() + ", signatureExpirationLedger=" + this.getSignatureExpirationLedger() + ", signature=" + this.getSignature() + ")";
    }

    @Generated
    public SorobanAddressCredentials() {
    }

    @Generated
    public SorobanAddressCredentials(SCAddress address, Int64 nonce, Uint32 signatureExpirationLedger, SCVal signature) {
        this.address = address;
        this.nonce = nonce;
        this.signatureExpirationLedger = signatureExpirationLedger;
        this.signature = signature;
    }

    @Generated
    public static class SorobanAddressCredentialsBuilder {
        @Generated
        private SCAddress address;
        @Generated
        private Int64 nonce;
        @Generated
        private Uint32 signatureExpirationLedger;
        @Generated
        private SCVal signature;

        @Generated
        SorobanAddressCredentialsBuilder() {
        }

        @Generated
        public SorobanAddressCredentialsBuilder address(SCAddress address) {
            this.address = address;
            return this;
        }

        @Generated
        public SorobanAddressCredentialsBuilder nonce(Int64 nonce) {
            this.nonce = nonce;
            return this;
        }

        @Generated
        public SorobanAddressCredentialsBuilder signatureExpirationLedger(Uint32 signatureExpirationLedger) {
            this.signatureExpirationLedger = signatureExpirationLedger;
            return this;
        }

        @Generated
        public SorobanAddressCredentialsBuilder signature(SCVal signature) {
            this.signature = signature;
            return this;
        }

        @Generated
        public SorobanAddressCredentials build() {
            return new SorobanAddressCredentials(this.address, this.nonce, this.signatureExpirationLedger, this.signature);
        }

        @Generated
        public String toString() {
            return "SorobanAddressCredentials.SorobanAddressCredentialsBuilder(address=" + this.address + ", nonce=" + this.nonce + ", signatureExpirationLedger=" + this.signatureExpirationLedger + ", signature=" + this.signature + ")";
        }
    }
}

