/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XdrDataOutputStream
extends DataOutputStream {
    private final XdrOutputStream mOut;

    public XdrDataOutputStream(OutputStream out) {
        super(new XdrOutputStream(out));
        this.mOut = (XdrOutputStream)this.out;
    }

    public void writeIntArray(int[] a) throws IOException {
        this.writeInt(a.length);
        this.writeIntArray(a, a.length);
    }

    private void writeIntArray(int[] a, int l) throws IOException {
        for (int i = 0; i < l; ++i) {
            this.writeInt(a[i]);
        }
    }

    public void writeFloatArray(float[] a) throws IOException {
        this.writeInt(a.length);
        this.writeFloatArray(a, a.length);
    }

    private void writeFloatArray(float[] a, int l) throws IOException {
        for (int i = 0; i < l; ++i) {
            this.writeFloat(a[i]);
        }
    }

    public void writeDoubleArray(double[] a) throws IOException {
        this.writeInt(a.length);
        this.writeDoubleArray(a, a.length);
    }

    private void writeDoubleArray(double[] a, int l) throws IOException {
        for (int i = 0; i < l; ++i) {
            this.writeDouble(a[i]);
        }
    }

    private static final class XdrOutputStream
    extends OutputStream {
        private final OutputStream mOut;
        private int mCount;

        public XdrOutputStream(OutputStream out) {
            this.mOut = out;
            this.mCount = 0;
        }

        @Override
        public void write(int b) throws IOException {
            this.mOut.write(b);
            ++this.mCount;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            this.mOut.write(b, offset, length);
            if (length > 0) {
                this.mCount += length;
                this.pad();
            }
        }

        public void pad() throws IOException {
            int pad = 0;
            int mod = this.mCount % 4;
            if (mod > 0) {
                pad = 4 - mod;
            }
            while (pad-- > 0) {
                this.write(0);
            }
        }
    }
}

