/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClaimableBalanceIDType;
import org.stellar.sdk.xdr.ContractID;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.MuxedEd25519Account;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCAddressType;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SCValType;

public class Address {
    private static final SCValType TYPE = SCValType.SCV_ADDRESS;
    private final byte[] key;
    private final AddressType type;

    public Address(String address) {
        if (StrKey.isValidEd25519PublicKey(address)) {
            this.type = AddressType.ACCOUNT;
            this.key = StrKey.decodeEd25519PublicKey(address);
        } else if (StrKey.isValidContract(address)) {
            this.type = AddressType.CONTRACT;
            this.key = StrKey.decodeContract(address);
        } else if (StrKey.isValidMed25519PublicKey(address)) {
            this.type = AddressType.MUXED_ACCOUNT;
            this.key = StrKey.decodeMed25519PublicKey(address);
        } else if (StrKey.isValidClaimableBalance(address)) {
            this.type = AddressType.CLAIMABLE_BALANCE;
            this.key = StrKey.decodeClaimableBalance(address);
        } else if (StrKey.isValidLiquidityPool(address)) {
            this.type = AddressType.LIQUIDITY_POOL;
            this.key = StrKey.decodeLiquidityPool(address);
        } else {
            throw new IllegalArgumentException("Unsupported address type");
        }
    }

    public static Address fromAccount(byte[] accountId) {
        return new Address(StrKey.encodeEd25519PublicKey(accountId));
    }

    public static Address fromContract(byte[] contractId) {
        return new Address(StrKey.encodeContract(contractId));
    }

    public static Address fromMuxedAccount(byte[] muxedAccountId) {
        return new Address(StrKey.encodeMed25519PublicKey(muxedAccountId));
    }

    public static Address fromClaimableBalance(byte[] claimableBalanceId) {
        return new Address(StrKey.encodeClaimableBalance(claimableBalanceId));
    }

    public static Address fromLiquidityPool(byte[] liquidityPoolId) {
        return new Address(StrKey.encodeLiquidityPool(liquidityPoolId));
    }

    public static Address fromSCAddress(SCAddress scAddress) {
        switch (scAddress.getDiscriminant()) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                return Address.fromAccount(scAddress.getAccountId().getAccountID().getEd25519().getUint256());
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                return Address.fromContract(scAddress.getContractId().getContractID().getHash());
            }
            case SC_ADDRESS_TYPE_MUXED_ACCOUNT: {
                return Address.fromMuxedAccount(StrKey.toRawMuxedAccountStrKey(new StrKey.RawMuxedAccountStrKeyParameter(scAddress.getMuxedAccount().getEd25519(), scAddress.getMuxedAccount().getId())));
            }
            case SC_ADDRESS_TYPE_CLAIMABLE_BALANCE: {
                if (scAddress.getClaimableBalanceId().getDiscriminant() != ClaimableBalanceIDType.CLAIMABLE_BALANCE_ID_TYPE_V0) {
                    throw new IllegalArgumentException("The claimable balance ID type is not supported, it must be `CLAIMABLE_BALANCE_ID_TYPE_V0`.");
                }
                byte[] v0Bytes = scAddress.getClaimableBalanceId().getV0().getHash();
                byte[] withZeroPrefix = new byte[v0Bytes.length + 1];
                withZeroPrefix[0] = 0;
                System.arraycopy(v0Bytes, 0, withZeroPrefix, 1, v0Bytes.length);
                return Address.fromClaimableBalance(withZeroPrefix);
            }
            case SC_ADDRESS_TYPE_LIQUIDITY_POOL: {
                return Address.fromLiquidityPool(scAddress.getLiquidityPoolId().getPoolID().getHash());
            }
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    public static Address fromSCVal(SCVal scVal) {
        if (!TYPE.equals(scVal.getDiscriminant())) {
            throw new IllegalArgumentException(String.format("invalid scVal type, expected %s, but got %s", TYPE, scVal.getDiscriminant()));
        }
        return Address.fromSCAddress(scVal.getAddress());
    }

    public SCAddress toSCAddress() {
        SCAddress scAddress = new SCAddress();
        switch (this.type) {
            case ACCOUNT: {
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_ACCOUNT);
                scAddress.setAccountId(KeyPair.fromPublicKey(this.key).getXdrAccountId());
                break;
            }
            case CONTRACT: {
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_CONTRACT);
                scAddress.setContractId(new ContractID(new Hash(this.key)));
                break;
            }
            case MUXED_ACCOUNT: {
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_MUXED_ACCOUNT);
                StrKey.RawMuxedAccountStrKeyParameter parameter = StrKey.fromRawMuxedAccountStrKey(this.key);
                MuxedEd25519Account muxedEd25519Account = MuxedEd25519Account.builder().id(parameter.getId()).ed25519(parameter.getEd25519()).build();
                scAddress.setMuxedAccount(muxedEd25519Account);
                break;
            }
            case CLAIMABLE_BALANCE: {
                if (this.key[0] != 0) {
                    throw new IllegalArgumentException("The claimable balance ID type is not supported, it must be `CLAIMABLE_BALANCE_ID_TYPE_V0`.");
                }
                byte[] hashBytes = Arrays.copyOfRange(this.key, 1, this.key.length);
                Hash hash = new Hash(hashBytes);
                ClaimableBalanceID claimableBalanceID = ClaimableBalanceID.builder().discriminant(ClaimableBalanceIDType.CLAIMABLE_BALANCE_ID_TYPE_V0).v0(hash).build();
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_CLAIMABLE_BALANCE);
                scAddress.setClaimableBalanceId(claimableBalanceID);
                break;
            }
            case LIQUIDITY_POOL: {
                scAddress.setDiscriminant(SCAddressType.SC_ADDRESS_TYPE_LIQUIDITY_POOL);
                try {
                    scAddress.setLiquidityPoolId(PoolID.fromXdrByteArray(this.key));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid liquidity pool ID", e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported address type");
            }
        }
        return scAddress;
    }

    public SCVal toSCVal() {
        SCVal scVal = new SCVal();
        scVal.setDiscriminant(TYPE);
        scVal.setAddress(this.toSCAddress());
        return scVal;
    }

    public byte[] getBytes() {
        return this.key;
    }

    public AddressType getAddressType() {
        return this.type;
    }

    public String getEncodedAddress() {
        switch (this.type) {
            case ACCOUNT: {
                return StrKey.encodeEd25519PublicKey(this.key);
            }
            case CONTRACT: {
                return StrKey.encodeContract(this.key);
            }
            case MUXED_ACCOUNT: {
                return StrKey.encodeMed25519PublicKey(this.key);
            }
            case CLAIMABLE_BALANCE: {
                return StrKey.encodeClaimableBalance(this.key);
            }
            case LIQUIDITY_POOL: {
                return StrKey.encodeLiquidityPool(this.key);
            }
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    public String toString() {
        return this.getEncodedAddress();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.key, other.key)) {
            return false;
        }
        AddressType this$type = this.type;
        AddressType other$type = other.type;
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.key);
        AddressType $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum AddressType {
        ACCOUNT,
        CONTRACT,
        MUXED_ACCOUNT,
        CLAIMABLE_BALANCE,
        LIQUIDITY_POOL;

    }
}

