/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.StrKey;

public abstract class AssetTypeCreditAlphaNum
extends Asset {
    @NonNull
    protected final String code;
    @NonNull
    protected final String issuer;

    public AssetTypeCreditAlphaNum(@NonNull String code, @NonNull String issuer) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        if (!StrKey.isValidEd25519PublicKey(issuer)) {
            throw new IllegalArgumentException("Invalid issuer: " + issuer);
        }
        this.code = code;
        this.issuer = issuer;
    }

    public String toString() {
        return this.getCode() + ":" + this.getIssuer();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetTypeCreditAlphaNum)) {
            return false;
        }
        AssetTypeCreditAlphaNum other = (AssetTypeCreditAlphaNum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        return !(this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetTypeCreditAlphaNum;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getCode() {
        return this.code;
    }

    @NonNull
    @Generated
    public String getIssuer() {
        return this.issuer;
    }
}

