/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetType;

public final class AssetTypeCreditAlphaNum12
extends AssetTypeCreditAlphaNum {
    public AssetTypeCreditAlphaNum12(String code, String issuer) {
        super(code, issuer);
        if (code.length() < 5 || code.length() > 12) {
            throw new IllegalArgumentException("The length of code must be between 5 and 12 characters.");
        }
    }

    @Override
    public AssetType getType() {
        return AssetType.ASSET_TYPE_CREDIT_ALPHANUM12;
    }

    public static AssetTypeCreditAlphaNum12 fromXdr(AlphaNum12 alphaNum12) {
        String assetCode12 = Util.paddedByteArrayToString(alphaNum12.getAssetCode().getAssetCode12());
        String accountId = StrKey.encodeEd25519PublicKey(alphaNum12.getIssuer().getAccountID().getEd25519().getUint256());
        return new AssetTypeCreditAlphaNum12(assetCode12, accountId);
    }

    @Override
    public org.stellar.sdk.xdr.Asset toXdr() {
        org.stellar.sdk.xdr.Asset xdr = new org.stellar.sdk.xdr.Asset();
        xdr.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM12);
        AlphaNum12 credit = new AlphaNum12();
        AssetCode12 assetCode12 = new AssetCode12();
        assetCode12.setAssetCode12(Util.paddedByteArray(this.code, 12));
        credit.setAssetCode(assetCode12);
        credit.setIssuer(KeyPair.fromAccountId(this.issuer).getXdrAccountId());
        xdr.setAlphaNum12(credit);
        return xdr;
    }

    @Override
    public int compareTo(@NonNull Asset other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (!AssetType.ASSET_TYPE_CREDIT_ALPHANUM12.equals(other.getType())) {
            return 1;
        }
        AssetTypeCreditAlphaNum o = (AssetTypeCreditAlphaNum)other;
        if (!this.getCode().equals(o.getCode())) {
            return this.getCode().compareTo(o.getCode());
        }
        return this.getIssuer().compareTo(o.getIssuer());
    }
}

