/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.LiquidityPool;
import org.stellar.sdk.xdr.AssetType;

public final class ChangeTrustAsset {
    @NonNull
    private final AssetType assetType;
    @Nullable
    private final Asset asset;
    @Nullable
    private final LiquidityPool liquidityPool;

    public ChangeTrustAsset(@NonNull Asset asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.assetType = asset.getType();
        this.asset = asset;
        this.liquidityPool = null;
    }

    public ChangeTrustAsset(@NonNull LiquidityPool liquidityPool) {
        if (liquidityPool == null) {
            throw new NullPointerException("liquidityPool is marked non-null but is null");
        }
        this.assetType = AssetType.ASSET_TYPE_POOL_SHARE;
        this.asset = null;
        this.liquidityPool = liquidityPool;
    }

    public org.stellar.sdk.xdr.ChangeTrustAsset toXdr() {
        org.stellar.sdk.xdr.ChangeTrustAsset xdr = new org.stellar.sdk.xdr.ChangeTrustAsset();
        if (this.asset != null) {
            org.stellar.sdk.xdr.Asset assetXdr = this.asset.toXdr();
            xdr.setDiscriminant(assetXdr.getDiscriminant());
            xdr.setAlphaNum4(assetXdr.getAlphaNum4());
            xdr.setAlphaNum12(assetXdr.getAlphaNum12());
        }
        if (this.liquidityPool != null) {
            xdr.setDiscriminant(AssetType.ASSET_TYPE_POOL_SHARE);
            xdr.setLiquidityPool(this.liquidityPool.toXdr());
        }
        return xdr;
    }

    public static ChangeTrustAsset fromXdr(org.stellar.sdk.xdr.ChangeTrustAsset changeTrustAsset) {
        switch (changeTrustAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return new ChangeTrustAsset(new AssetTypeNative());
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                return new ChangeTrustAsset(AssetTypeCreditAlphaNum4.fromXdr(changeTrustAsset.getAlphaNum4()));
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                return new ChangeTrustAsset(AssetTypeCreditAlphaNum12.fromXdr(changeTrustAsset.getAlphaNum12()));
            }
            case ASSET_TYPE_POOL_SHARE: {
                return new ChangeTrustAsset(LiquidityPool.fromXdr(changeTrustAsset.getLiquidityPool()));
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + changeTrustAsset.getDiscriminant());
    }

    @NonNull
    @Generated
    public AssetType getAssetType() {
        return this.assetType;
    }

    @Nullable
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Nullable
    @Generated
    public LiquidityPool getLiquidityPool() {
        return this.liquidityPool;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTrustAsset)) {
            return false;
        }
        ChangeTrustAsset other = (ChangeTrustAsset)o;
        AssetType this$assetType = this.getAssetType();
        AssetType other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        LiquidityPool this$liquidityPool = this.getLiquidityPool();
        LiquidityPool other$liquidityPool = other.getLiquidityPool();
        return !(this$liquidityPool == null ? other$liquidityPool != null : !((Object)this$liquidityPool).equals(other$liquidityPool));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        LiquidityPool $liquidityPool = this.getLiquidityPool();
        result = result * 59 + ($liquidityPool == null ? 43 : ((Object)$liquidityPool).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChangeTrustAsset(assetType=" + this.getAssetType() + ", asset=" + this.getAsset() + ", liquidityPool=" + this.getLiquidityPool() + ")";
    }
}

