/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class MuxedAccount {
    @NonNull
    private final String accountId;
    @Nullable
    private final BigInteger muxedId;

    public MuxedAccount(@NonNull String accountId, @Nullable BigInteger muxedId) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (!StrKey.isValidEd25519PublicKey(accountId)) {
            throw new IllegalArgumentException("accountId is invalid");
        }
        this.accountId = accountId;
        this.muxedId = muxedId;
    }

    public MuxedAccount(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (StrKey.isValidEd25519PublicKey(address)) {
            this.accountId = address;
            this.muxedId = null;
        } else if (StrKey.isValidMed25519PublicKey(address)) {
            byte[] rawMed25519 = StrKey.decodeMed25519PublicKey(address);
            StrKey.RawMuxedAccountStrKeyParameter parameter = StrKey.fromRawMuxedAccountStrKey(rawMed25519);
            this.accountId = StrKey.encodeEd25519PublicKey(parameter.getEd25519().getUint256());
            this.muxedId = parameter.getId().getUint64().getNumber();
        } else {
            throw new IllegalArgumentException("Invalid address");
        }
    }

    public String getAddress() {
        if (this.muxedId == null) {
            return this.accountId;
        }
        MuxedAccount.MuxedAccountMed25519 med25519 = this.toXdr().getMed25519();
        return StrKey.encodeMed25519PublicKey(StrKey.toRawMuxedAccountStrKey(new StrKey.RawMuxedAccountStrKeyParameter(med25519.getEd25519(), med25519.getId())));
    }

    public static MuxedAccount fromXdr(org.stellar.sdk.xdr.MuxedAccount xdr) {
        switch (xdr.getDiscriminant()) {
            case KEY_TYPE_ED25519: {
                return new MuxedAccount(StrKey.encodeEd25519PublicKey(xdr.getEd25519().getUint256()), null);
            }
            case KEY_TYPE_MUXED_ED25519: {
                return new MuxedAccount(StrKey.encodeEd25519PublicKey(xdr.getMed25519().getEd25519().getUint256()), xdr.getMed25519().getId().getUint64().getNumber());
            }
        }
        throw new IllegalArgumentException("Invalid address");
    }

    public org.stellar.sdk.xdr.MuxedAccount toXdr() {
        if (this.muxedId == null) {
            return new org.stellar.sdk.xdr.MuxedAccount(CryptoKeyType.KEY_TYPE_ED25519, new Uint256(StrKey.decodeEd25519PublicKey(this.accountId)), null);
        }
        return new org.stellar.sdk.xdr.MuxedAccount(CryptoKeyType.KEY_TYPE_MUXED_ED25519, null, new MuxedAccount.MuxedAccountMed25519(new Uint64(new XdrUnsignedHyperInteger(this.muxedId)), new Uint256(StrKey.decodeEd25519PublicKey(this.accountId))));
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    @Generated
    public BigInteger getMuxedId() {
        return this.muxedId;
    }

    @Generated
    public String toString() {
        return "MuxedAccount(accountId=" + this.getAccountId() + ", muxedId=" + this.getMuxedId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MuxedAccount)) {
            return false;
        }
        MuxedAccount other = (MuxedAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        BigInteger this$muxedId = this.getMuxedId();
        BigInteger other$muxedId = other.getMuxedId();
        return !(this$muxedId == null ? other$muxedId != null : !((Object)this$muxedId).equals(other$muxedId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MuxedAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        BigInteger $muxedId = this.getMuxedId();
        result = result * 59 + ($muxedId == null ? 43 : ((Object)$muxedId).hashCode());
        return result;
    }
}

