/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.BumpSequenceOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SequenceNumber;

public class BumpSequenceOperation
extends Operation {
    private final long bumpTo;

    public static BumpSequenceOperation fromXdr(BumpSequenceOp op) {
        return new BumpSequenceOperation(op.getBumpTo().getSequenceNumber().getInt64());
    }

    @Override
    Operation.OperationBody toOperationBody() {
        BumpSequenceOp op = new BumpSequenceOp();
        Int64 bumpTo = new Int64();
        bumpTo.setInt64(this.bumpTo);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(bumpTo);
        op.setBumpTo(sequenceNumber);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.BUMP_SEQUENCE);
        body.setBumpSequenceOp(op);
        return body;
    }

    @Generated
    protected BumpSequenceOperation(BumpSequenceOperationBuilder<?, ?> b) {
        super(b);
        this.bumpTo = ((BumpSequenceOperationBuilder)b).bumpTo;
    }

    @Generated
    public static BumpSequenceOperationBuilder<?, ?> builder() {
        return new BumpSequenceOperationBuilderImpl();
    }

    @Generated
    public BumpSequenceOperationBuilder<?, ?> toBuilder() {
        return new BumpSequenceOperationBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public long getBumpTo() {
        return this.bumpTo;
    }

    @Generated
    public String toString() {
        return "BumpSequenceOperation(super=" + super.toString() + ", bumpTo=" + this.getBumpTo() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BumpSequenceOperation)) {
            return false;
        }
        BumpSequenceOperation other = (BumpSequenceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getBumpTo() == other.getBumpTo();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BumpSequenceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $bumpTo = this.getBumpTo();
        result = result * 59 + (int)($bumpTo >>> 32 ^ $bumpTo);
        return result;
    }

    @Generated
    private BumpSequenceOperation(long bumpTo) {
        this.bumpTo = bumpTo;
    }

    @Generated
    private static final class BumpSequenceOperationBuilderImpl
    extends BumpSequenceOperationBuilder<BumpSequenceOperation, BumpSequenceOperationBuilderImpl> {
        @Generated
        private BumpSequenceOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected BumpSequenceOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BumpSequenceOperation build() {
            return new BumpSequenceOperation(this);
        }
    }

    @Generated
    public static abstract class BumpSequenceOperationBuilder<C extends BumpSequenceOperation, B extends BumpSequenceOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private long bumpTo;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BumpSequenceOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BumpSequenceOperation instance, BumpSequenceOperationBuilder<?, ?> b) {
            b.bumpTo(instance.bumpTo);
        }

        @Generated
        public B bumpTo(long bumpTo) {
            this.bumpTo = bumpTo;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BumpSequenceOperation.BumpSequenceOperationBuilder(super=" + super.toString() + ", bumpTo=" + this.bumpTo + ")";
        }
    }
}

