/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.sorobanrpc;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.DiagnosticEvent;
import org.stellar.sdk.xdr.TransactionEvent;

public final class Events {
    private final List<String> diagnosticEventsXdr;
    private final List<String> transactionEventsXdr;
    private final List<List<String>> contractEventsXdr;

    public List<DiagnosticEvent> parseDiagnosticEventsXdr() {
        if (this.diagnosticEventsXdr == null) {
            return null;
        }
        return this.diagnosticEventsXdr.stream().map(xdr -> Util.parseXdr(xdr, DiagnosticEvent::fromXdrBase64)).collect(Collectors.toList());
    }

    public List<TransactionEvent> parseTransactionEventsXdr() {
        if (this.transactionEventsXdr == null) {
            return null;
        }
        return this.transactionEventsXdr.stream().map(xdr -> Util.parseXdr(xdr, TransactionEvent::fromXdrBase64)).collect(Collectors.toList());
    }

    public List<List<ContractEvent>> parseContractEventsXdr() {
        if (this.contractEventsXdr == null) {
            return null;
        }
        return this.contractEventsXdr.stream().map(events -> events.stream().map(xdr -> Util.parseXdr(xdr, ContractEvent::fromXdrBase64)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Generated
    public Events(List<String> diagnosticEventsXdr, List<String> transactionEventsXdr, List<List<String>> contractEventsXdr) {
        this.diagnosticEventsXdr = diagnosticEventsXdr;
        this.transactionEventsXdr = transactionEventsXdr;
        this.contractEventsXdr = contractEventsXdr;
    }

    @Generated
    public List<String> getDiagnosticEventsXdr() {
        return this.diagnosticEventsXdr;
    }

    @Generated
    public List<String> getTransactionEventsXdr() {
        return this.transactionEventsXdr;
    }

    @Generated
    public List<List<String>> getContractEventsXdr() {
        return this.contractEventsXdr;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Events)) {
            return false;
        }
        Events other = (Events)o;
        List<String> this$diagnosticEventsXdr = this.getDiagnosticEventsXdr();
        List<String> other$diagnosticEventsXdr = other.getDiagnosticEventsXdr();
        if (this$diagnosticEventsXdr == null ? other$diagnosticEventsXdr != null : !((Object)this$diagnosticEventsXdr).equals(other$diagnosticEventsXdr)) {
            return false;
        }
        List<String> this$transactionEventsXdr = this.getTransactionEventsXdr();
        List<String> other$transactionEventsXdr = other.getTransactionEventsXdr();
        if (this$transactionEventsXdr == null ? other$transactionEventsXdr != null : !((Object)this$transactionEventsXdr).equals(other$transactionEventsXdr)) {
            return false;
        }
        List<List<String>> this$contractEventsXdr = this.getContractEventsXdr();
        List<List<String>> other$contractEventsXdr = other.getContractEventsXdr();
        return !(this$contractEventsXdr == null ? other$contractEventsXdr != null : !((Object)this$contractEventsXdr).equals(other$contractEventsXdr));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $diagnosticEventsXdr = this.getDiagnosticEventsXdr();
        result = result * 59 + ($diagnosticEventsXdr == null ? 43 : ((Object)$diagnosticEventsXdr).hashCode());
        List<String> $transactionEventsXdr = this.getTransactionEventsXdr();
        result = result * 59 + ($transactionEventsXdr == null ? 43 : ((Object)$transactionEventsXdr).hashCode());
        List<List<String>> $contractEventsXdr = this.getContractEventsXdr();
        result = result * 59 + ($contractEventsXdr == null ? 43 : ((Object)$contractEventsXdr).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Events(diagnosticEventsXdr=" + this.getDiagnosticEventsXdr() + ", transactionEventsXdr=" + this.getTransactionEventsXdr() + ", contractEventsXdr=" + this.getContractEventsXdr() + ")";
    }
}

