/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AlphaNum4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Asset
implements XdrElement {
    private AssetType discriminant;
    private AlphaNum4 alphaNum4;
    private AlphaNum12 alphaNum12;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                this.alphaNum4.encode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                this.alphaNum12.encode(stream);
            }
        }
    }

    public static Asset decode(XdrDataInputStream stream) throws IOException {
        Asset decodedAsset = new Asset();
        AssetType discriminant = AssetType.decode(stream);
        decodedAsset.setDiscriminant(discriminant);
        switch (decodedAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedAsset.alphaNum4 = AlphaNum4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedAsset.alphaNum12 = AlphaNum12.decode(stream);
            }
        }
        return decodedAsset;
    }

    public static Asset fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Asset.fromXdrByteArray(bytes);
    }

    public static Asset fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Asset.decode(xdrDataInputStream);
    }

    @Generated
    public static AssetBuilder builder() {
        return new AssetBuilder();
    }

    @Generated
    public AssetBuilder toBuilder() {
        return new AssetBuilder().discriminant(this.discriminant).alphaNum4(this.alphaNum4).alphaNum12(this.alphaNum12);
    }

    @Generated
    public AssetType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AlphaNum4 getAlphaNum4() {
        return this.alphaNum4;
    }

    @Generated
    public AlphaNum12 getAlphaNum12() {
        return this.alphaNum12;
    }

    @Generated
    public void setDiscriminant(AssetType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAlphaNum4(AlphaNum4 alphaNum4) {
        this.alphaNum4 = alphaNum4;
    }

    @Generated
    public void setAlphaNum12(AlphaNum12 alphaNum12) {
        this.alphaNum12 = alphaNum12;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetType this$discriminant = this.getDiscriminant();
        AssetType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        AlphaNum4 this$alphaNum4 = this.getAlphaNum4();
        AlphaNum4 other$alphaNum4 = other.getAlphaNum4();
        if (this$alphaNum4 == null ? other$alphaNum4 != null : !((Object)this$alphaNum4).equals(other$alphaNum4)) {
            return false;
        }
        AlphaNum12 this$alphaNum12 = this.getAlphaNum12();
        AlphaNum12 other$alphaNum12 = other.getAlphaNum12();
        return !(this$alphaNum12 == null ? other$alphaNum12 != null : !((Object)this$alphaNum12).equals(other$alphaNum12));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Asset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        AlphaNum4 $alphaNum4 = this.getAlphaNum4();
        result = result * 59 + ($alphaNum4 == null ? 43 : ((Object)$alphaNum4).hashCode());
        AlphaNum12 $alphaNum12 = this.getAlphaNum12();
        result = result * 59 + ($alphaNum12 == null ? 43 : ((Object)$alphaNum12).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Asset(discriminant=" + this.getDiscriminant() + ", alphaNum4=" + this.getAlphaNum4() + ", alphaNum12=" + this.getAlphaNum12() + ")";
    }

    @Generated
    public Asset() {
    }

    @Generated
    public Asset(AssetType discriminant, AlphaNum4 alphaNum4, AlphaNum12 alphaNum12) {
        this.discriminant = discriminant;
        this.alphaNum4 = alphaNum4;
        this.alphaNum12 = alphaNum12;
    }

    @Generated
    public static class AssetBuilder {
        @Generated
        private AssetType discriminant;
        @Generated
        private AlphaNum4 alphaNum4;
        @Generated
        private AlphaNum12 alphaNum12;

        @Generated
        AssetBuilder() {
        }

        @Generated
        public AssetBuilder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public AssetBuilder alphaNum4(AlphaNum4 alphaNum4) {
            this.alphaNum4 = alphaNum4;
            return this;
        }

        @Generated
        public AssetBuilder alphaNum12(AlphaNum12 alphaNum12) {
            this.alphaNum12 = alphaNum12;
            return this;
        }

        @Generated
        public Asset build() {
            return new Asset(this.discriminant, this.alphaNum4, this.alphaNum12);
        }

        @Generated
        public String toString() {
            return "Asset.AssetBuilder(discriminant=" + this.discriminant + ", alphaNum4=" + this.alphaNum4 + ", alphaNum12=" + this.alphaNum12 + ")";
        }
    }
}

