/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class CreateAccountOp
implements XdrElement {
    private AccountID destination;
    private Int64 startingBalance;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.destination.encode(stream);
        this.startingBalance.encode(stream);
    }

    public static CreateAccountOp decode(XdrDataInputStream stream) throws IOException {
        CreateAccountOp decodedCreateAccountOp = new CreateAccountOp();
        decodedCreateAccountOp.destination = AccountID.decode(stream);
        decodedCreateAccountOp.startingBalance = Int64.decode(stream);
        return decodedCreateAccountOp;
    }

    public static CreateAccountOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateAccountOp.fromXdrByteArray(bytes);
    }

    public static CreateAccountOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateAccountOp.decode(xdrDataInputStream);
    }

    @Generated
    public static CreateAccountOpBuilder builder() {
        return new CreateAccountOpBuilder();
    }

    @Generated
    public CreateAccountOpBuilder toBuilder() {
        return new CreateAccountOpBuilder().destination(this.destination).startingBalance(this.startingBalance);
    }

    @Generated
    public AccountID getDestination() {
        return this.destination;
    }

    @Generated
    public Int64 getStartingBalance() {
        return this.startingBalance;
    }

    @Generated
    public void setDestination(AccountID destination) {
        this.destination = destination;
    }

    @Generated
    public void setStartingBalance(Int64 startingBalance) {
        this.startingBalance = startingBalance;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAccountOp)) {
            return false;
        }
        CreateAccountOp other = (CreateAccountOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$destination = this.getDestination();
        AccountID other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Int64 this$startingBalance = this.getStartingBalance();
        Int64 other$startingBalance = other.getStartingBalance();
        return !(this$startingBalance == null ? other$startingBalance != null : !((Object)this$startingBalance).equals(other$startingBalance));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateAccountOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Int64 $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : ((Object)$startingBalance).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateAccountOp(destination=" + this.getDestination() + ", startingBalance=" + this.getStartingBalance() + ")";
    }

    @Generated
    public CreateAccountOp() {
    }

    @Generated
    public CreateAccountOp(AccountID destination, Int64 startingBalance) {
        this.destination = destination;
        this.startingBalance = startingBalance;
    }

    @Generated
    public static class CreateAccountOpBuilder {
        @Generated
        private AccountID destination;
        @Generated
        private Int64 startingBalance;

        @Generated
        CreateAccountOpBuilder() {
        }

        @Generated
        public CreateAccountOpBuilder destination(AccountID destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public CreateAccountOpBuilder startingBalance(Int64 startingBalance) {
            this.startingBalance = startingBalance;
            return this;
        }

        @Generated
        public CreateAccountOp build() {
            return new CreateAccountOp(this.destination, this.startingBalance);
        }

        @Generated
        public String toString() {
            return "CreateAccountOp.CreateAccountOpBuilder(destination=" + this.destination + ", startingBalance=" + this.startingBalance + ")";
        }
    }
}

