/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.DataValue;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class DataEntry
implements XdrElement {
    private AccountID accountID;
    private String64 dataName;
    private DataValue dataValue;
    private DataEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.accountID.encode(stream);
        this.dataName.encode(stream);
        this.dataValue.encode(stream);
        this.ext.encode(stream);
    }

    public static DataEntry decode(XdrDataInputStream stream) throws IOException {
        DataEntry decodedDataEntry = new DataEntry();
        decodedDataEntry.accountID = AccountID.decode(stream);
        decodedDataEntry.dataName = String64.decode(stream);
        decodedDataEntry.dataValue = DataValue.decode(stream);
        decodedDataEntry.ext = DataEntryExt.decode(stream);
        return decodedDataEntry;
    }

    public static DataEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return DataEntry.fromXdrByteArray(bytes);
    }

    public static DataEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return DataEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static DataEntryBuilder builder() {
        return new DataEntryBuilder();
    }

    @Generated
    public DataEntryBuilder toBuilder() {
        return new DataEntryBuilder().accountID(this.accountID).dataName(this.dataName).dataValue(this.dataValue).ext(this.ext);
    }

    @Generated
    public AccountID getAccountID() {
        return this.accountID;
    }

    @Generated
    public String64 getDataName() {
        return this.dataName;
    }

    @Generated
    public DataValue getDataValue() {
        return this.dataValue;
    }

    @Generated
    public DataEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setAccountID(AccountID accountID) {
        this.accountID = accountID;
    }

    @Generated
    public void setDataName(String64 dataName) {
        this.dataName = dataName;
    }

    @Generated
    public void setDataValue(DataValue dataValue) {
        this.dataValue = dataValue;
    }

    @Generated
    public void setExt(DataEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEntry)) {
            return false;
        }
        DataEntry other = (DataEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$accountID = this.getAccountID();
        AccountID other$accountID = other.getAccountID();
        if (this$accountID == null ? other$accountID != null : !((Object)this$accountID).equals(other$accountID)) {
            return false;
        }
        String64 this$dataName = this.getDataName();
        String64 other$dataName = other.getDataName();
        if (this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName)) {
            return false;
        }
        DataValue this$dataValue = this.getDataValue();
        DataValue other$dataValue = other.getDataValue();
        if (this$dataValue == null ? other$dataValue != null : !((Object)this$dataValue).equals(other$dataValue)) {
            return false;
        }
        DataEntryExt this$ext = this.getExt();
        DataEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $accountID = this.getAccountID();
        result = result * 59 + ($accountID == null ? 43 : ((Object)$accountID).hashCode());
        String64 $dataName = this.getDataName();
        result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
        DataValue $dataValue = this.getDataValue();
        result = result * 59 + ($dataValue == null ? 43 : ((Object)$dataValue).hashCode());
        DataEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataEntry(accountID=" + this.getAccountID() + ", dataName=" + this.getDataName() + ", dataValue=" + this.getDataValue() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public DataEntry() {
    }

    @Generated
    public DataEntry(AccountID accountID, String64 dataName, DataValue dataValue, DataEntryExt ext) {
        this.accountID = accountID;
        this.dataName = dataName;
        this.dataValue = dataValue;
        this.ext = ext;
    }

    @Generated
    public static class DataEntryBuilder {
        @Generated
        private AccountID accountID;
        @Generated
        private String64 dataName;
        @Generated
        private DataValue dataValue;
        @Generated
        private DataEntryExt ext;

        @Generated
        DataEntryBuilder() {
        }

        @Generated
        public DataEntryBuilder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        @Generated
        public DataEntryBuilder dataName(String64 dataName) {
            this.dataName = dataName;
            return this;
        }

        @Generated
        public DataEntryBuilder dataValue(DataValue dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        @Generated
        public DataEntryBuilder ext(DataEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public DataEntry build() {
            return new DataEntry(this.accountID, this.dataName, this.dataValue, this.ext);
        }

        @Generated
        public String toString() {
            return "DataEntry.DataEntryBuilder(accountID=" + this.accountID + ", dataName=" + this.dataName + ", dataValue=" + this.dataValue + ", ext=" + this.ext + ")";
        }
    }

    public static class DataEntryExt
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static DataEntryExt decode(XdrDataInputStream stream) throws IOException {
            DataEntryExt decodedDataEntryExt = new DataEntryExt();
            Integer discriminant = stream.readInt();
            decodedDataEntryExt.setDiscriminant(discriminant);
            switch (decodedDataEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedDataEntryExt;
        }

        public static DataEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return DataEntryExt.fromXdrByteArray(bytes);
        }

        public static DataEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return DataEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static DataEntryExtBuilder builder() {
            return new DataEntryExtBuilder();
        }

        @Generated
        public DataEntryExtBuilder toBuilder() {
            return new DataEntryExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataEntryExt)) {
                return false;
            }
            DataEntryExt other = (DataEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DataEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DataEntry.DataEntryExt(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public DataEntryExt() {
        }

        @Generated
        public DataEntryExt(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class DataEntryExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            DataEntryExtBuilder() {
            }

            @Generated
            public DataEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public DataEntryExt build() {
                return new DataEntryExt(this.discriminant);
            }

            @Generated
            public String toString() {
                return "DataEntry.DataEntryExt.DataEntryExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }
}

