/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class EvictionIterator
implements XdrElement {
    private Uint32 bucketListLevel;
    private Boolean isCurrBucket;
    private Uint64 bucketFileOffset;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.bucketListLevel.encode(stream);
        stream.writeInt(this.isCurrBucket != false ? 1 : 0);
        this.bucketFileOffset.encode(stream);
    }

    public static EvictionIterator decode(XdrDataInputStream stream) throws IOException {
        EvictionIterator decodedEvictionIterator = new EvictionIterator();
        decodedEvictionIterator.bucketListLevel = Uint32.decode(stream);
        decodedEvictionIterator.isCurrBucket = stream.readInt() == 1;
        decodedEvictionIterator.bucketFileOffset = Uint64.decode(stream);
        return decodedEvictionIterator;
    }

    public static EvictionIterator fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return EvictionIterator.fromXdrByteArray(bytes);
    }

    public static EvictionIterator fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return EvictionIterator.decode(xdrDataInputStream);
    }

    @Generated
    public static EvictionIteratorBuilder builder() {
        return new EvictionIteratorBuilder();
    }

    @Generated
    public EvictionIteratorBuilder toBuilder() {
        return new EvictionIteratorBuilder().bucketListLevel(this.bucketListLevel).isCurrBucket(this.isCurrBucket).bucketFileOffset(this.bucketFileOffset);
    }

    @Generated
    public Uint32 getBucketListLevel() {
        return this.bucketListLevel;
    }

    @Generated
    public Boolean getIsCurrBucket() {
        return this.isCurrBucket;
    }

    @Generated
    public Uint64 getBucketFileOffset() {
        return this.bucketFileOffset;
    }

    @Generated
    public void setBucketListLevel(Uint32 bucketListLevel) {
        this.bucketListLevel = bucketListLevel;
    }

    @Generated
    public void setIsCurrBucket(Boolean isCurrBucket) {
        this.isCurrBucket = isCurrBucket;
    }

    @Generated
    public void setBucketFileOffset(Uint64 bucketFileOffset) {
        this.bucketFileOffset = bucketFileOffset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvictionIterator)) {
            return false;
        }
        EvictionIterator other = (EvictionIterator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isCurrBucket = this.getIsCurrBucket();
        Boolean other$isCurrBucket = other.getIsCurrBucket();
        if (this$isCurrBucket == null ? other$isCurrBucket != null : !((Object)this$isCurrBucket).equals(other$isCurrBucket)) {
            return false;
        }
        Uint32 this$bucketListLevel = this.getBucketListLevel();
        Uint32 other$bucketListLevel = other.getBucketListLevel();
        if (this$bucketListLevel == null ? other$bucketListLevel != null : !((Object)this$bucketListLevel).equals(other$bucketListLevel)) {
            return false;
        }
        Uint64 this$bucketFileOffset = this.getBucketFileOffset();
        Uint64 other$bucketFileOffset = other.getBucketFileOffset();
        return !(this$bucketFileOffset == null ? other$bucketFileOffset != null : !((Object)this$bucketFileOffset).equals(other$bucketFileOffset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EvictionIterator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isCurrBucket = this.getIsCurrBucket();
        result = result * 59 + ($isCurrBucket == null ? 43 : ((Object)$isCurrBucket).hashCode());
        Uint32 $bucketListLevel = this.getBucketListLevel();
        result = result * 59 + ($bucketListLevel == null ? 43 : ((Object)$bucketListLevel).hashCode());
        Uint64 $bucketFileOffset = this.getBucketFileOffset();
        result = result * 59 + ($bucketFileOffset == null ? 43 : ((Object)$bucketFileOffset).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EvictionIterator(bucketListLevel=" + this.getBucketListLevel() + ", isCurrBucket=" + this.getIsCurrBucket() + ", bucketFileOffset=" + this.getBucketFileOffset() + ")";
    }

    @Generated
    public EvictionIterator() {
    }

    @Generated
    public EvictionIterator(Uint32 bucketListLevel, Boolean isCurrBucket, Uint64 bucketFileOffset) {
        this.bucketListLevel = bucketListLevel;
        this.isCurrBucket = isCurrBucket;
        this.bucketFileOffset = bucketFileOffset;
    }

    @Generated
    public static class EvictionIteratorBuilder {
        @Generated
        private Uint32 bucketListLevel;
        @Generated
        private Boolean isCurrBucket;
        @Generated
        private Uint64 bucketFileOffset;

        @Generated
        EvictionIteratorBuilder() {
        }

        @Generated
        public EvictionIteratorBuilder bucketListLevel(Uint32 bucketListLevel) {
            this.bucketListLevel = bucketListLevel;
            return this;
        }

        @Generated
        public EvictionIteratorBuilder isCurrBucket(Boolean isCurrBucket) {
            this.isCurrBucket = isCurrBucket;
            return this;
        }

        @Generated
        public EvictionIteratorBuilder bucketFileOffset(Uint64 bucketFileOffset) {
            this.bucketFileOffset = bucketFileOffset;
            return this;
        }

        @Generated
        public EvictionIterator build() {
            return new EvictionIterator(this.bucketListLevel, this.isCurrBucket, this.bucketFileOffset);
        }

        @Generated
        public String toString() {
            return "EvictionIterator.EvictionIteratorBuilder(bucketListLevel=" + this.bucketListLevel + ", isCurrBucket=" + this.isCurrBucket + ", bucketFileOffset=" + this.bucketFileOffset + ")";
        }
    }
}

