/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum HotArchiveBucketEntryType implements XdrElement
{
    HOT_ARCHIVE_METAENTRY(-1),
    HOT_ARCHIVE_ARCHIVED(0),
    HOT_ARCHIVE_LIVE(1);

    private final int value;

    private HotArchiveBucketEntryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HotArchiveBucketEntryType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case -1: {
                return HOT_ARCHIVE_METAENTRY;
            }
            case 0: {
                return HOT_ARCHIVE_ARCHIVED;
            }
            case 1: {
                return HOT_ARCHIVE_LIVE;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static HotArchiveBucketEntryType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HotArchiveBucketEntryType.fromXdrByteArray(bytes);
    }

    public static HotArchiveBucketEntryType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HotArchiveBucketEntryType.decode(xdrDataInputStream);
    }
}

