/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class MuxedEd25519Account
implements XdrElement {
    private Uint64 id;
    private Uint256 ed25519;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.id.encode(stream);
        this.ed25519.encode(stream);
    }

    public static MuxedEd25519Account decode(XdrDataInputStream stream) throws IOException {
        MuxedEd25519Account decodedMuxedEd25519Account = new MuxedEd25519Account();
        decodedMuxedEd25519Account.id = Uint64.decode(stream);
        decodedMuxedEd25519Account.ed25519 = Uint256.decode(stream);
        return decodedMuxedEd25519Account;
    }

    public static MuxedEd25519Account fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return MuxedEd25519Account.fromXdrByteArray(bytes);
    }

    public static MuxedEd25519Account fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return MuxedEd25519Account.decode(xdrDataInputStream);
    }

    @Generated
    public static MuxedEd25519AccountBuilder builder() {
        return new MuxedEd25519AccountBuilder();
    }

    @Generated
    public MuxedEd25519AccountBuilder toBuilder() {
        return new MuxedEd25519AccountBuilder().id(this.id).ed25519(this.ed25519);
    }

    @Generated
    public Uint64 getId() {
        return this.id;
    }

    @Generated
    public Uint256 getEd25519() {
        return this.ed25519;
    }

    @Generated
    public void setId(Uint64 id) {
        this.id = id;
    }

    @Generated
    public void setEd25519(Uint256 ed25519) {
        this.ed25519 = ed25519;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MuxedEd25519Account)) {
            return false;
        }
        MuxedEd25519Account other = (MuxedEd25519Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint64 this$id = this.getId();
        Uint64 other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Uint256 this$ed25519 = this.getEd25519();
        Uint256 other$ed25519 = other.getEd25519();
        return !(this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MuxedEd25519Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint64 $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Uint256 $ed25519 = this.getEd25519();
        result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MuxedEd25519Account(id=" + this.getId() + ", ed25519=" + this.getEd25519() + ")";
    }

    @Generated
    public MuxedEd25519Account() {
    }

    @Generated
    public MuxedEd25519Account(Uint64 id, Uint256 ed25519) {
        this.id = id;
        this.ed25519 = ed25519;
    }

    @Generated
    public static class MuxedEd25519AccountBuilder {
        @Generated
        private Uint64 id;
        @Generated
        private Uint256 ed25519;

        @Generated
        MuxedEd25519AccountBuilder() {
        }

        @Generated
        public MuxedEd25519AccountBuilder id(Uint64 id) {
            this.id = id;
            return this;
        }

        @Generated
        public MuxedEd25519AccountBuilder ed25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
            return this;
        }

        @Generated
        public MuxedEd25519Account build() {
            return new MuxedEd25519Account(this.id, this.ed25519);
        }

        @Generated
        public String toString() {
            return "MuxedEd25519Account.MuxedEd25519AccountBuilder(id=" + this.id + ", ed25519=" + this.ed25519 + ")";
        }
    }
}

