/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerSCPMessages;
import org.stellar.sdk.xdr.SCPQuorumSet;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPHistoryEntryV0
implements XdrElement {
    private SCPQuorumSet[] quorumSets;
    private LedgerSCPMessages ledgerMessages;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int quorumSetsSize = this.getQuorumSets().length;
        stream.writeInt(quorumSetsSize);
        for (int i = 0; i < quorumSetsSize; ++i) {
            this.quorumSets[i].encode(stream);
        }
        this.ledgerMessages.encode(stream);
    }

    public static SCPHistoryEntryV0 decode(XdrDataInputStream stream) throws IOException {
        SCPHistoryEntryV0 decodedSCPHistoryEntryV0 = new SCPHistoryEntryV0();
        int quorumSetsSize = stream.readInt();
        decodedSCPHistoryEntryV0.quorumSets = new SCPQuorumSet[quorumSetsSize];
        for (int i = 0; i < quorumSetsSize; ++i) {
            decodedSCPHistoryEntryV0.quorumSets[i] = SCPQuorumSet.decode(stream);
        }
        decodedSCPHistoryEntryV0.ledgerMessages = LedgerSCPMessages.decode(stream);
        return decodedSCPHistoryEntryV0;
    }

    public static SCPHistoryEntryV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPHistoryEntryV0.fromXdrByteArray(bytes);
    }

    public static SCPHistoryEntryV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPHistoryEntryV0.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPHistoryEntryV0Builder builder() {
        return new SCPHistoryEntryV0Builder();
    }

    @Generated
    public SCPHistoryEntryV0Builder toBuilder() {
        return new SCPHistoryEntryV0Builder().quorumSets(this.quorumSets).ledgerMessages(this.ledgerMessages);
    }

    @Generated
    public SCPQuorumSet[] getQuorumSets() {
        return this.quorumSets;
    }

    @Generated
    public LedgerSCPMessages getLedgerMessages() {
        return this.ledgerMessages;
    }

    @Generated
    public void setQuorumSets(SCPQuorumSet[] quorumSets) {
        this.quorumSets = quorumSets;
    }

    @Generated
    public void setLedgerMessages(LedgerSCPMessages ledgerMessages) {
        this.ledgerMessages = ledgerMessages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPHistoryEntryV0)) {
            return false;
        }
        SCPHistoryEntryV0 other = (SCPHistoryEntryV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getQuorumSets(), other.getQuorumSets())) {
            return false;
        }
        LedgerSCPMessages this$ledgerMessages = this.getLedgerMessages();
        LedgerSCPMessages other$ledgerMessages = other.getLedgerMessages();
        return !(this$ledgerMessages == null ? other$ledgerMessages != null : !((Object)this$ledgerMessages).equals(other$ledgerMessages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPHistoryEntryV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getQuorumSets());
        LedgerSCPMessages $ledgerMessages = this.getLedgerMessages();
        result = result * 59 + ($ledgerMessages == null ? 43 : ((Object)$ledgerMessages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPHistoryEntryV0(quorumSets=" + Arrays.deepToString(this.getQuorumSets()) + ", ledgerMessages=" + this.getLedgerMessages() + ")";
    }

    @Generated
    public SCPHistoryEntryV0() {
    }

    @Generated
    public SCPHistoryEntryV0(SCPQuorumSet[] quorumSets, LedgerSCPMessages ledgerMessages) {
        this.quorumSets = quorumSets;
        this.ledgerMessages = ledgerMessages;
    }

    @Generated
    public static class SCPHistoryEntryV0Builder {
        @Generated
        private SCPQuorumSet[] quorumSets;
        @Generated
        private LedgerSCPMessages ledgerMessages;

        @Generated
        SCPHistoryEntryV0Builder() {
        }

        @Generated
        public SCPHistoryEntryV0Builder quorumSets(SCPQuorumSet[] quorumSets) {
            this.quorumSets = quorumSets;
            return this;
        }

        @Generated
        public SCPHistoryEntryV0Builder ledgerMessages(LedgerSCPMessages ledgerMessages) {
            this.ledgerMessages = ledgerMessages;
            return this;
        }

        @Generated
        public SCPHistoryEntryV0 build() {
            return new SCPHistoryEntryV0(this.quorumSets, this.ledgerMessages);
        }

        @Generated
        public String toString() {
            return "SCPHistoryEntryV0.SCPHistoryEntryV0Builder(quorumSets=" + Arrays.deepToString(this.quorumSets) + ", ledgerMessages=" + this.ledgerMessages + ")";
        }
    }
}

