/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecEventDataFormat;
import org.stellar.sdk.xdr.SCSpecEventParamV0;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecEventV0
implements XdrElement {
    private XdrString doc;
    private XdrString lib;
    private SCSymbol name;
    private SCSymbol[] prefixTopics;
    private SCSpecEventParamV0[] params;
    private SCSpecEventDataFormat dataFormat;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.doc.encode(stream);
        this.lib.encode(stream);
        this.name.encode(stream);
        int prefixTopicsSize = this.getPrefixTopics().length;
        stream.writeInt(prefixTopicsSize);
        for (int i = 0; i < prefixTopicsSize; ++i) {
            this.prefixTopics[i].encode(stream);
        }
        int paramsSize = this.getParams().length;
        stream.writeInt(paramsSize);
        for (int i = 0; i < paramsSize; ++i) {
            this.params[i].encode(stream);
        }
        this.dataFormat.encode(stream);
    }

    public static SCSpecEventV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecEventV0 decodedSCSpecEventV0 = new SCSpecEventV0();
        decodedSCSpecEventV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecEventV0.lib = XdrString.decode(stream, 80);
        decodedSCSpecEventV0.name = SCSymbol.decode(stream);
        int prefixTopicsSize = stream.readInt();
        decodedSCSpecEventV0.prefixTopics = new SCSymbol[prefixTopicsSize];
        for (int i = 0; i < prefixTopicsSize; ++i) {
            decodedSCSpecEventV0.prefixTopics[i] = SCSymbol.decode(stream);
        }
        int paramsSize = stream.readInt();
        decodedSCSpecEventV0.params = new SCSpecEventParamV0[paramsSize];
        for (int i = 0; i < paramsSize; ++i) {
            decodedSCSpecEventV0.params[i] = SCSpecEventParamV0.decode(stream);
        }
        decodedSCSpecEventV0.dataFormat = SCSpecEventDataFormat.decode(stream);
        return decodedSCSpecEventV0;
    }

    public static SCSpecEventV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecEventV0.fromXdrByteArray(bytes);
    }

    public static SCSpecEventV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecEventV0.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecEventV0Builder builder() {
        return new SCSpecEventV0Builder();
    }

    @Generated
    public SCSpecEventV0Builder toBuilder() {
        return new SCSpecEventV0Builder().doc(this.doc).lib(this.lib).name(this.name).prefixTopics(this.prefixTopics).params(this.params).dataFormat(this.dataFormat);
    }

    @Generated
    public XdrString getDoc() {
        return this.doc;
    }

    @Generated
    public XdrString getLib() {
        return this.lib;
    }

    @Generated
    public SCSymbol getName() {
        return this.name;
    }

    @Generated
    public SCSymbol[] getPrefixTopics() {
        return this.prefixTopics;
    }

    @Generated
    public SCSpecEventParamV0[] getParams() {
        return this.params;
    }

    @Generated
    public SCSpecEventDataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Generated
    public void setDoc(XdrString doc) {
        this.doc = doc;
    }

    @Generated
    public void setLib(XdrString lib) {
        this.lib = lib;
    }

    @Generated
    public void setName(SCSymbol name) {
        this.name = name;
    }

    @Generated
    public void setPrefixTopics(SCSymbol[] prefixTopics) {
        this.prefixTopics = prefixTopics;
    }

    @Generated
    public void setParams(SCSpecEventParamV0[] params) {
        this.params = params;
    }

    @Generated
    public void setDataFormat(SCSpecEventDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecEventV0)) {
            return false;
        }
        SCSpecEventV0 other = (SCSpecEventV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XdrString this$doc = this.getDoc();
        XdrString other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        XdrString this$lib = this.getLib();
        XdrString other$lib = other.getLib();
        if (this$lib == null ? other$lib != null : !((Object)this$lib).equals(other$lib)) {
            return false;
        }
        SCSymbol this$name = this.getName();
        SCSymbol other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPrefixTopics(), other.getPrefixTopics())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getParams(), other.getParams())) {
            return false;
        }
        SCSpecEventDataFormat this$dataFormat = this.getDataFormat();
        SCSpecEventDataFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecEventV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XdrString $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        XdrString $lib = this.getLib();
        result = result * 59 + ($lib == null ? 43 : ((Object)$lib).hashCode());
        SCSymbol $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPrefixTopics());
        result = result * 59 + Arrays.deepHashCode(this.getParams());
        SCSpecEventDataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecEventV0(doc=" + this.getDoc() + ", lib=" + this.getLib() + ", name=" + this.getName() + ", prefixTopics=" + Arrays.deepToString(this.getPrefixTopics()) + ", params=" + Arrays.deepToString(this.getParams()) + ", dataFormat=" + this.getDataFormat() + ")";
    }

    @Generated
    public SCSpecEventV0() {
    }

    @Generated
    public SCSpecEventV0(XdrString doc, XdrString lib, SCSymbol name, SCSymbol[] prefixTopics, SCSpecEventParamV0[] params, SCSpecEventDataFormat dataFormat) {
        this.doc = doc;
        this.lib = lib;
        this.name = name;
        this.prefixTopics = prefixTopics;
        this.params = params;
        this.dataFormat = dataFormat;
    }

    @Generated
    public static class SCSpecEventV0Builder {
        @Generated
        private XdrString doc;
        @Generated
        private XdrString lib;
        @Generated
        private SCSymbol name;
        @Generated
        private SCSymbol[] prefixTopics;
        @Generated
        private SCSpecEventParamV0[] params;
        @Generated
        private SCSpecEventDataFormat dataFormat;

        @Generated
        SCSpecEventV0Builder() {
        }

        @Generated
        public SCSpecEventV0Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        @Generated
        public SCSpecEventV0Builder lib(XdrString lib) {
            this.lib = lib;
            return this;
        }

        @Generated
        public SCSpecEventV0Builder name(SCSymbol name) {
            this.name = name;
            return this;
        }

        @Generated
        public SCSpecEventV0Builder prefixTopics(SCSymbol[] prefixTopics) {
            this.prefixTopics = prefixTopics;
            return this;
        }

        @Generated
        public SCSpecEventV0Builder params(SCSpecEventParamV0[] params) {
            this.params = params;
            return this;
        }

        @Generated
        public SCSpecEventV0Builder dataFormat(SCSpecEventDataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Generated
        public SCSpecEventV0 build() {
            return new SCSpecEventV0(this.doc, this.lib, this.name, this.prefixTopics, this.params, this.dataFormat);
        }

        @Generated
        public String toString() {
            return "SCSpecEventV0.SCSpecEventV0Builder(doc=" + this.doc + ", lib=" + this.lib + ", name=" + this.name + ", prefixTopics=" + Arrays.deepToString(this.prefixTopics) + ", params=" + Arrays.deepToString(this.params) + ", dataFormat=" + this.dataFormat + ")";
        }
    }
}

