/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCSpecTypeTuple
implements XdrElement {
    private SCSpecTypeDef[] valueTypes;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int valueTypesSize = this.getValueTypes().length;
        stream.writeInt(valueTypesSize);
        for (int i = 0; i < valueTypesSize; ++i) {
            this.valueTypes[i].encode(stream);
        }
    }

    public static SCSpecTypeTuple decode(XdrDataInputStream stream) throws IOException {
        SCSpecTypeTuple decodedSCSpecTypeTuple = new SCSpecTypeTuple();
        int valueTypesSize = stream.readInt();
        decodedSCSpecTypeTuple.valueTypes = new SCSpecTypeDef[valueTypesSize];
        for (int i = 0; i < valueTypesSize; ++i) {
            decodedSCSpecTypeTuple.valueTypes[i] = SCSpecTypeDef.decode(stream);
        }
        return decodedSCSpecTypeTuple;
    }

    public static SCSpecTypeTuple fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecTypeTuple.fromXdrByteArray(bytes);
    }

    public static SCSpecTypeTuple fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecTypeTuple.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecTypeTupleBuilder builder() {
        return new SCSpecTypeTupleBuilder();
    }

    @Generated
    public SCSpecTypeTupleBuilder toBuilder() {
        return new SCSpecTypeTupleBuilder().valueTypes(this.valueTypes);
    }

    @Generated
    public SCSpecTypeDef[] getValueTypes() {
        return this.valueTypes;
    }

    @Generated
    public void setValueTypes(SCSpecTypeDef[] valueTypes) {
        this.valueTypes = valueTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecTypeTuple)) {
            return false;
        }
        SCSpecTypeTuple other = (SCSpecTypeTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getValueTypes(), other.getValueTypes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecTypeTuple;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getValueTypes());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecTypeTuple(valueTypes=" + Arrays.deepToString(this.getValueTypes()) + ")";
    }

    @Generated
    public SCSpecTypeTuple() {
    }

    @Generated
    public SCSpecTypeTuple(SCSpecTypeDef[] valueTypes) {
        this.valueTypes = valueTypes;
    }

    @Generated
    public static class SCSpecTypeTupleBuilder {
        @Generated
        private SCSpecTypeDef[] valueTypes;

        @Generated
        SCSpecTypeTupleBuilder() {
        }

        @Generated
        public SCSpecTypeTupleBuilder valueTypes(SCSpecTypeDef[] valueTypes) {
            this.valueTypes = valueTypes;
            return this;
        }

        @Generated
        public SCSpecTypeTuple build() {
            return new SCSpecTypeTuple(this.valueTypes);
        }

        @Generated
        public String toString() {
            return "SCSpecTypeTuple.SCSpecTypeTupleBuilder(valueTypes=" + Arrays.deepToString(this.valueTypes) + ")";
        }
    }
}

