/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.GeneralizedTransactionSet;
import org.stellar.sdk.xdr.TransactionSet;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionHistoryEntry
implements XdrElement {
    private Uint32 ledgerSeq;
    private TransactionSet txSet;
    private TransactionHistoryEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ledgerSeq.encode(stream);
        this.txSet.encode(stream);
        this.ext.encode(stream);
    }

    public static TransactionHistoryEntry decode(XdrDataInputStream stream) throws IOException {
        TransactionHistoryEntry decodedTransactionHistoryEntry = new TransactionHistoryEntry();
        decodedTransactionHistoryEntry.ledgerSeq = Uint32.decode(stream);
        decodedTransactionHistoryEntry.txSet = TransactionSet.decode(stream);
        decodedTransactionHistoryEntry.ext = TransactionHistoryEntryExt.decode(stream);
        return decodedTransactionHistoryEntry;
    }

    public static TransactionHistoryEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionHistoryEntry.fromXdrByteArray(bytes);
    }

    public static TransactionHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionHistoryEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionHistoryEntryBuilder builder() {
        return new TransactionHistoryEntryBuilder();
    }

    @Generated
    public TransactionHistoryEntryBuilder toBuilder() {
        return new TransactionHistoryEntryBuilder().ledgerSeq(this.ledgerSeq).txSet(this.txSet).ext(this.ext);
    }

    @Generated
    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    @Generated
    public TransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public TransactionHistoryEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setLedgerSeq(Uint32 ledgerSeq) {
        this.ledgerSeq = ledgerSeq;
    }

    @Generated
    public void setTxSet(TransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setExt(TransactionHistoryEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionHistoryEntry)) {
            return false;
        }
        TransactionHistoryEntry other = (TransactionHistoryEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$ledgerSeq = this.getLedgerSeq();
        Uint32 other$ledgerSeq = other.getLedgerSeq();
        if (this$ledgerSeq == null ? other$ledgerSeq != null : !((Object)this$ledgerSeq).equals(other$ledgerSeq)) {
            return false;
        }
        TransactionSet this$txSet = this.getTxSet();
        TransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        TransactionHistoryEntryExt this$ext = this.getExt();
        TransactionHistoryEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionHistoryEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $ledgerSeq = this.getLedgerSeq();
        result = result * 59 + ($ledgerSeq == null ? 43 : ((Object)$ledgerSeq).hashCode());
        TransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        TransactionHistoryEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionHistoryEntry(ledgerSeq=" + this.getLedgerSeq() + ", txSet=" + this.getTxSet() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public TransactionHistoryEntry() {
    }

    @Generated
    public TransactionHistoryEntry(Uint32 ledgerSeq, TransactionSet txSet, TransactionHistoryEntryExt ext) {
        this.ledgerSeq = ledgerSeq;
        this.txSet = txSet;
        this.ext = ext;
    }

    @Generated
    public static class TransactionHistoryEntryBuilder {
        @Generated
        private Uint32 ledgerSeq;
        @Generated
        private TransactionSet txSet;
        @Generated
        private TransactionHistoryEntryExt ext;

        @Generated
        TransactionHistoryEntryBuilder() {
        }

        @Generated
        public TransactionHistoryEntryBuilder ledgerSeq(Uint32 ledgerSeq) {
            this.ledgerSeq = ledgerSeq;
            return this;
        }

        @Generated
        public TransactionHistoryEntryBuilder txSet(TransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public TransactionHistoryEntryBuilder ext(TransactionHistoryEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TransactionHistoryEntry build() {
            return new TransactionHistoryEntry(this.ledgerSeq, this.txSet, this.ext);
        }

        @Generated
        public String toString() {
            return "TransactionHistoryEntry.TransactionHistoryEntryBuilder(ledgerSeq=" + this.ledgerSeq + ", txSet=" + this.txSet + ", ext=" + this.ext + ")";
        }
    }

    public static class TransactionHistoryEntryExt
    implements XdrElement {
        private Integer discriminant;
        private GeneralizedTransactionSet generalizedTxSet;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.generalizedTxSet.encode(stream);
                }
            }
        }

        public static TransactionHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
            TransactionHistoryEntryExt decodedTransactionHistoryEntryExt = new TransactionHistoryEntryExt();
            Integer discriminant = stream.readInt();
            decodedTransactionHistoryEntryExt.setDiscriminant(discriminant);
            switch (decodedTransactionHistoryEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedTransactionHistoryEntryExt.generalizedTxSet = GeneralizedTransactionSet.decode(stream);
                }
            }
            return decodedTransactionHistoryEntryExt;
        }

        public static TransactionHistoryEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionHistoryEntryExt.fromXdrByteArray(bytes);
        }

        public static TransactionHistoryEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionHistoryEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static TransactionHistoryEntryExtBuilder builder() {
            return new TransactionHistoryEntryExtBuilder();
        }

        @Generated
        public TransactionHistoryEntryExtBuilder toBuilder() {
            return new TransactionHistoryEntryExtBuilder().discriminant(this.discriminant).generalizedTxSet(this.generalizedTxSet);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public GeneralizedTransactionSet getGeneralizedTxSet() {
            return this.generalizedTxSet;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setGeneralizedTxSet(GeneralizedTransactionSet generalizedTxSet) {
            this.generalizedTxSet = generalizedTxSet;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionHistoryEntryExt)) {
                return false;
            }
            TransactionHistoryEntryExt other = (TransactionHistoryEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            GeneralizedTransactionSet this$generalizedTxSet = this.getGeneralizedTxSet();
            GeneralizedTransactionSet other$generalizedTxSet = other.getGeneralizedTxSet();
            return !(this$generalizedTxSet == null ? other$generalizedTxSet != null : !((Object)this$generalizedTxSet).equals(other$generalizedTxSet));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionHistoryEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            GeneralizedTransactionSet $generalizedTxSet = this.getGeneralizedTxSet();
            result = result * 59 + ($generalizedTxSet == null ? 43 : ((Object)$generalizedTxSet).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionHistoryEntry.TransactionHistoryEntryExt(discriminant=" + this.getDiscriminant() + ", generalizedTxSet=" + this.getGeneralizedTxSet() + ")";
        }

        @Generated
        public TransactionHistoryEntryExt() {
        }

        @Generated
        public TransactionHistoryEntryExt(Integer discriminant, GeneralizedTransactionSet generalizedTxSet) {
            this.discriminant = discriminant;
            this.generalizedTxSet = generalizedTxSet;
        }

        @Generated
        public static class TransactionHistoryEntryExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private GeneralizedTransactionSet generalizedTxSet;

            @Generated
            TransactionHistoryEntryExtBuilder() {
            }

            @Generated
            public TransactionHistoryEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TransactionHistoryEntryExtBuilder generalizedTxSet(GeneralizedTransactionSet generalizedTxSet) {
                this.generalizedTxSet = generalizedTxSet;
                return this;
            }

            @Generated
            public TransactionHistoryEntryExt build() {
                return new TransactionHistoryEntryExt(this.discriminant, this.generalizedTxSet);
            }

            @Generated
            public String toString() {
                return "TransactionHistoryEntry.TransactionHistoryEntryExt.TransactionHistoryEntryExtBuilder(discriminant=" + this.discriminant + ", generalizedTxSet=" + this.generalizedTxSet + ")";
            }
        }
    }
}

