// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ClawbackResult's original definition in the XDR file is:
 *
 * <pre>
 * union ClawbackResult switch (ClawbackResultCode code)
 * {
 * case CLAWBACK_SUCCESS:
 *     void;
 * case CLAWBACK_MALFORMED:
 * case CLAWBACK_NOT_CLAWBACK_ENABLED:
 * case CLAWBACK_NO_TRUST:
 * case CLAWBACK_UNDERFUNDED:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ClawbackResult implements XdrElement {
  private ClawbackResultCode discriminant;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case CLAWBACK_SUCCESS:
        break;
      case CLAWBACK_MALFORMED:
      case CLAWBACK_NOT_CLAWBACK_ENABLED:
      case CLAWBACK_NO_TRUST:
      case CLAWBACK_UNDERFUNDED:
        break;
    }
  }

  public static ClawbackResult decode(XdrDataInputStream stream) throws IOException {
    ClawbackResult decodedClawbackResult = new ClawbackResult();
    ClawbackResultCode discriminant = ClawbackResultCode.decode(stream);
    decodedClawbackResult.setDiscriminant(discriminant);
    switch (decodedClawbackResult.getDiscriminant()) {
      case CLAWBACK_SUCCESS:
        break;
      case CLAWBACK_MALFORMED:
      case CLAWBACK_NOT_CLAWBACK_ENABLED:
      case CLAWBACK_NO_TRUST:
      case CLAWBACK_UNDERFUNDED:
        break;
    }
    return decodedClawbackResult;
  }

  public static ClawbackResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ClawbackResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
