// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * EvictionIterator's original definition in the XDR file is:
 *
 * <pre>
 * struct EvictionIterator {
 *     uint32 bucketListLevel;
 *     bool isCurrBucket;
 *     uint64 bucketFileOffset;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class EvictionIterator implements XdrElement {
  private Uint32 bucketListLevel;
  private Boolean isCurrBucket;
  private Uint64 bucketFileOffset;

  public void encode(XdrDataOutputStream stream) throws IOException {
    bucketListLevel.encode(stream);
    stream.writeInt(isCurrBucket ? 1 : 0);
    bucketFileOffset.encode(stream);
  }

  public static EvictionIterator decode(XdrDataInputStream stream) throws IOException {
    EvictionIterator decodedEvictionIterator = new EvictionIterator();
    decodedEvictionIterator.bucketListLevel = Uint32.decode(stream);
    decodedEvictionIterator.isCurrBucket = stream.readInt() == 1 ? true : false;
    decodedEvictionIterator.bucketFileOffset = Uint64.decode(stream);
    return decodedEvictionIterator;
  }

  public static EvictionIterator fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static EvictionIterator fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
