// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * IPAddrType's original definition in the XDR file is:
 *
 * <pre>
 * enum IPAddrType
 * {
 *     IPv4 = 0,
 *     IPv6 = 1
 * };
 * </pre>
 */
public enum IPAddrType implements XdrElement {
  IPv4(0),
  IPv6(1);

  private final int value;

  IPAddrType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static IPAddrType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return IPv4;
      case 1:
        return IPv6;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static IPAddrType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static IPAddrType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
