// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerCloseMetaV2's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerCloseMetaV2
 * {
 *     LedgerCloseMetaExt ext;
 *
 *     LedgerHeaderHistoryEntry ledgerHeader;
 *
 *     GeneralizedTransactionSet txSet;
 *
 *     // NB: transactions are sorted in apply order here
 *     // fees for all transactions are processed first
 *     // followed by applying transactions
 *     TransactionResultMetaV1 txProcessing&lt;&gt;;
 *
 *     // upgrades are applied last
 *     UpgradeEntryMeta upgradesProcessing&lt;&gt;;
 *
 *     // other misc information attached to the ledger close
 *     SCPHistoryEntry scpInfo&lt;&gt;;
 *
 *     // Size in bytes of live Soroban state, to support downstream
 *     // systems calculating storage fees correctly.
 *     uint64 totalByteSizeOfLiveSorobanState;
 *
 *     // TTL and data/code keys that have been evicted at this ledger.
 *     LedgerKey evictedKeys&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerCloseMetaV2 implements XdrElement {
  private LedgerCloseMetaExt ext;
  private LedgerHeaderHistoryEntry ledgerHeader;
  private GeneralizedTransactionSet txSet;
  private TransactionResultMetaV1[] txProcessing;
  private UpgradeEntryMeta[] upgradesProcessing;
  private SCPHistoryEntry[] scpInfo;
  private Uint64 totalByteSizeOfLiveSorobanState;
  private LedgerKey[] evictedKeys;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    ledgerHeader.encode(stream);
    txSet.encode(stream);
    int txProcessingSize = getTxProcessing().length;
    stream.writeInt(txProcessingSize);
    for (int i = 0; i < txProcessingSize; i++) {
      txProcessing[i].encode(stream);
    }
    int upgradesProcessingSize = getUpgradesProcessing().length;
    stream.writeInt(upgradesProcessingSize);
    for (int i = 0; i < upgradesProcessingSize; i++) {
      upgradesProcessing[i].encode(stream);
    }
    int scpInfoSize = getScpInfo().length;
    stream.writeInt(scpInfoSize);
    for (int i = 0; i < scpInfoSize; i++) {
      scpInfo[i].encode(stream);
    }
    totalByteSizeOfLiveSorobanState.encode(stream);
    int evictedKeysSize = getEvictedKeys().length;
    stream.writeInt(evictedKeysSize);
    for (int i = 0; i < evictedKeysSize; i++) {
      evictedKeys[i].encode(stream);
    }
  }

  public static LedgerCloseMetaV2 decode(XdrDataInputStream stream) throws IOException {
    LedgerCloseMetaV2 decodedLedgerCloseMetaV2 = new LedgerCloseMetaV2();
    decodedLedgerCloseMetaV2.ext = LedgerCloseMetaExt.decode(stream);
    decodedLedgerCloseMetaV2.ledgerHeader = LedgerHeaderHistoryEntry.decode(stream);
    decodedLedgerCloseMetaV2.txSet = GeneralizedTransactionSet.decode(stream);
    int txProcessingSize = stream.readInt();
    decodedLedgerCloseMetaV2.txProcessing = new TransactionResultMetaV1[txProcessingSize];
    for (int i = 0; i < txProcessingSize; i++) {
      decodedLedgerCloseMetaV2.txProcessing[i] = TransactionResultMetaV1.decode(stream);
    }
    int upgradesProcessingSize = stream.readInt();
    decodedLedgerCloseMetaV2.upgradesProcessing = new UpgradeEntryMeta[upgradesProcessingSize];
    for (int i = 0; i < upgradesProcessingSize; i++) {
      decodedLedgerCloseMetaV2.upgradesProcessing[i] = UpgradeEntryMeta.decode(stream);
    }
    int scpInfoSize = stream.readInt();
    decodedLedgerCloseMetaV2.scpInfo = new SCPHistoryEntry[scpInfoSize];
    for (int i = 0; i < scpInfoSize; i++) {
      decodedLedgerCloseMetaV2.scpInfo[i] = SCPHistoryEntry.decode(stream);
    }
    decodedLedgerCloseMetaV2.totalByteSizeOfLiveSorobanState = Uint64.decode(stream);
    int evictedKeysSize = stream.readInt();
    decodedLedgerCloseMetaV2.evictedKeys = new LedgerKey[evictedKeysSize];
    for (int i = 0; i < evictedKeysSize; i++) {
      decodedLedgerCloseMetaV2.evictedKeys[i] = LedgerKey.decode(stream);
    }
    return decodedLedgerCloseMetaV2;
  }

  public static LedgerCloseMetaV2 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerCloseMetaV2 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
