// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LiquidityPoolConstantProductParameters's original definition in the XDR file is:
 *
 * <pre>
 * struct LiquidityPoolConstantProductParameters
 * {
 *     Asset assetA; // assetA &lt; assetB
 *     Asset assetB;
 *     int32 fee; // Fee is in basis points, so the actual rate is (fee/100)%
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LiquidityPoolConstantProductParameters implements XdrElement {
  private Asset assetA;
  private Asset assetB;
  private Int32 fee;

  public void encode(XdrDataOutputStream stream) throws IOException {
    assetA.encode(stream);
    assetB.encode(stream);
    fee.encode(stream);
  }

  public static LiquidityPoolConstantProductParameters decode(XdrDataInputStream stream)
      throws IOException {
    LiquidityPoolConstantProductParameters decodedLiquidityPoolConstantProductParameters =
        new LiquidityPoolConstantProductParameters();
    decodedLiquidityPoolConstantProductParameters.assetA = Asset.decode(stream);
    decodedLiquidityPoolConstantProductParameters.assetB = Asset.decode(stream);
    decodedLiquidityPoolConstantProductParameters.fee = Int32.decode(stream);
    return decodedLiquidityPoolConstantProductParameters;
  }

  public static LiquidityPoolConstantProductParameters fromXdrBase64(String xdr)
      throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LiquidityPoolConstantProductParameters fromXdrByteArray(byte[] xdr)
      throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
