// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * OperationMetaV2's original definition in the XDR file is:
 *
 * <pre>
 * struct OperationMetaV2
 * {
 *     ExtensionPoint ext;
 *
 *     LedgerEntryChanges changes;
 *
 *     ContractEvent events&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class OperationMetaV2 implements XdrElement {
  private ExtensionPoint ext;
  private LedgerEntryChanges changes;
  private ContractEvent[] events;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    changes.encode(stream);
    int eventsSize = getEvents().length;
    stream.writeInt(eventsSize);
    for (int i = 0; i < eventsSize; i++) {
      events[i].encode(stream);
    }
  }

  public static OperationMetaV2 decode(XdrDataInputStream stream) throws IOException {
    OperationMetaV2 decodedOperationMetaV2 = new OperationMetaV2();
    decodedOperationMetaV2.ext = ExtensionPoint.decode(stream);
    decodedOperationMetaV2.changes = LedgerEntryChanges.decode(stream);
    int eventsSize = stream.readInt();
    decodedOperationMetaV2.events = new ContractEvent[eventsSize];
    for (int i = 0; i < eventsSize; i++) {
      decodedOperationMetaV2.events[i] = ContractEvent.decode(stream);
    }
    return decodedOperationMetaV2;
  }

  public static OperationMetaV2 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static OperationMetaV2 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
