// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ParallelTxsComponent's original definition in the XDR file is:
 *
 * <pre>
 * struct ParallelTxsComponent
 * {
 *   int64&#42; baseFee;
 *   // A sequence of stages that &#42;may&#42; have arbitrary data dependencies between
 *   // each other, i.e. in a general case the stage execution order may not be
 *   // arbitrarily shuffled without affecting the end result.
 *   ParallelTxExecutionStage executionStages&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ParallelTxsComponent implements XdrElement {
  private Int64 baseFee;
  private ParallelTxExecutionStage[] executionStages;

  public void encode(XdrDataOutputStream stream) throws IOException {
    if (baseFee != null) {
      stream.writeInt(1);
      baseFee.encode(stream);
    } else {
      stream.writeInt(0);
    }
    int executionStagesSize = getExecutionStages().length;
    stream.writeInt(executionStagesSize);
    for (int i = 0; i < executionStagesSize; i++) {
      executionStages[i].encode(stream);
    }
  }

  public static ParallelTxsComponent decode(XdrDataInputStream stream) throws IOException {
    ParallelTxsComponent decodedParallelTxsComponent = new ParallelTxsComponent();
    int baseFeePresent = stream.readInt();
    if (baseFeePresent != 0) {
      decodedParallelTxsComponent.baseFee = Int64.decode(stream);
    }
    int executionStagesSize = stream.readInt();
    decodedParallelTxsComponent.executionStages = new ParallelTxExecutionStage[executionStagesSize];
    for (int i = 0; i < executionStagesSize; i++) {
      decodedParallelTxsComponent.executionStages[i] = ParallelTxExecutionStage.decode(stream);
    }
    return decodedParallelTxsComponent;
  }

  public static ParallelTxsComponent fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ParallelTxsComponent fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
