// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * SCErrorType's original definition in the XDR file is:
 *
 * <pre>
 * enum SCErrorType
 * {
 *     SCE_CONTRACT = 0,          // Contract-specific, user-defined codes.
 *     SCE_WASM_VM = 1,           // Errors while interpreting WASM bytecode.
 *     SCE_CONTEXT = 2,           // Errors in the contract's host context.
 *     SCE_STORAGE = 3,           // Errors accessing host storage.
 *     SCE_OBJECT = 4,            // Errors working with host objects.
 *     SCE_CRYPTO = 5,            // Errors in cryptographic operations.
 *     SCE_EVENTS = 6,            // Errors while emitting events.
 *     SCE_BUDGET = 7,            // Errors relating to budget limits.
 *     SCE_VALUE = 8,             // Errors working with host values or SCVals.
 *     SCE_AUTH = 9               // Errors from the authentication subsystem.
 * };
 * </pre>
 */
public enum SCErrorType implements XdrElement {
  SCE_CONTRACT(0),
  SCE_WASM_VM(1),
  SCE_CONTEXT(2),
  SCE_STORAGE(3),
  SCE_OBJECT(4),
  SCE_CRYPTO(5),
  SCE_EVENTS(6),
  SCE_BUDGET(7),
  SCE_VALUE(8),
  SCE_AUTH(9);

  private final int value;

  SCErrorType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static SCErrorType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return SCE_CONTRACT;
      case 1:
        return SCE_WASM_VM;
      case 2:
        return SCE_CONTEXT;
      case 3:
        return SCE_STORAGE;
      case 4:
        return SCE_OBJECT;
      case 5:
        return SCE_CRYPTO;
      case 6:
        return SCE_EVENTS;
      case 7:
        return SCE_BUDGET;
      case 8:
        return SCE_VALUE;
      case 9:
        return SCE_AUTH;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static SCErrorType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCErrorType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
