// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TimeSlicedNodeData's original definition in the XDR file is:
 *
 * <pre>
 * struct TimeSlicedNodeData
 * {
 *     uint32 addedAuthenticatedPeers;
 *     uint32 droppedAuthenticatedPeers;
 *     uint32 totalInboundPeerCount;
 *     uint32 totalOutboundPeerCount;
 *
 *     // SCP stats
 *     uint32 p75SCPFirstToSelfLatencyMs;
 *     uint32 p75SCPSelfToOtherLatencyMs;
 *
 *     // How many times the node lost sync in the time slice
 *     uint32 lostSyncCount;
 *
 *     // Config data
 *     bool isValidator;
 *     uint32 maxInboundPeerCount;
 *     uint32 maxOutboundPeerCount;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TimeSlicedNodeData implements XdrElement {
  private Uint32 addedAuthenticatedPeers;
  private Uint32 droppedAuthenticatedPeers;
  private Uint32 totalInboundPeerCount;
  private Uint32 totalOutboundPeerCount;
  private Uint32 p75SCPFirstToSelfLatencyMs;
  private Uint32 p75SCPSelfToOtherLatencyMs;
  private Uint32 lostSyncCount;
  private Boolean isValidator;
  private Uint32 maxInboundPeerCount;
  private Uint32 maxOutboundPeerCount;

  public void encode(XdrDataOutputStream stream) throws IOException {
    addedAuthenticatedPeers.encode(stream);
    droppedAuthenticatedPeers.encode(stream);
    totalInboundPeerCount.encode(stream);
    totalOutboundPeerCount.encode(stream);
    p75SCPFirstToSelfLatencyMs.encode(stream);
    p75SCPSelfToOtherLatencyMs.encode(stream);
    lostSyncCount.encode(stream);
    stream.writeInt(isValidator ? 1 : 0);
    maxInboundPeerCount.encode(stream);
    maxOutboundPeerCount.encode(stream);
  }

  public static TimeSlicedNodeData decode(XdrDataInputStream stream) throws IOException {
    TimeSlicedNodeData decodedTimeSlicedNodeData = new TimeSlicedNodeData();
    decodedTimeSlicedNodeData.addedAuthenticatedPeers = Uint32.decode(stream);
    decodedTimeSlicedNodeData.droppedAuthenticatedPeers = Uint32.decode(stream);
    decodedTimeSlicedNodeData.totalInboundPeerCount = Uint32.decode(stream);
    decodedTimeSlicedNodeData.totalOutboundPeerCount = Uint32.decode(stream);
    decodedTimeSlicedNodeData.p75SCPFirstToSelfLatencyMs = Uint32.decode(stream);
    decodedTimeSlicedNodeData.p75SCPSelfToOtherLatencyMs = Uint32.decode(stream);
    decodedTimeSlicedNodeData.lostSyncCount = Uint32.decode(stream);
    decodedTimeSlicedNodeData.isValidator = stream.readInt() == 1 ? true : false;
    decodedTimeSlicedNodeData.maxInboundPeerCount = Uint32.decode(stream);
    decodedTimeSlicedNodeData.maxOutboundPeerCount = Uint32.decode(stream);
    return decodedTimeSlicedNodeData;
  }

  public static TimeSlicedNodeData fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TimeSlicedNodeData fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
