// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionPhase's original definition in the XDR file is:
 *
 * <pre>
 * union TransactionPhase switch (int v)
 * {
 * case 0:
 *     TxSetComponent v0Components&lt;&gt;;
 * case 1:
 *     ParallelTxsComponent parallelTxsComponent;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionPhase implements XdrElement {
  private Integer discriminant;
  private TxSetComponent[] v0Components;
  private ParallelTxsComponent parallelTxsComponent;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant);
    switch (discriminant) {
      case 0:
        int v0ComponentsSize = getV0Components().length;
        stream.writeInt(v0ComponentsSize);
        for (int i = 0; i < v0ComponentsSize; i++) {
          v0Components[i].encode(stream);
        }
        break;
      case 1:
        parallelTxsComponent.encode(stream);
        break;
    }
  }

  public static TransactionPhase decode(XdrDataInputStream stream) throws IOException {
    TransactionPhase decodedTransactionPhase = new TransactionPhase();
    Integer discriminant = stream.readInt();
    decodedTransactionPhase.setDiscriminant(discriminant);
    switch (decodedTransactionPhase.getDiscriminant()) {
      case 0:
        int v0ComponentsSize = stream.readInt();
        decodedTransactionPhase.v0Components = new TxSetComponent[v0ComponentsSize];
        for (int i = 0; i < v0ComponentsSize; i++) {
          decodedTransactionPhase.v0Components[i] = TxSetComponent.decode(stream);
        }
        break;
      case 1:
        decodedTransactionPhase.parallelTxsComponent = ParallelTxsComponent.decode(stream);
        break;
    }
    return decodedTransactionPhase;
  }

  public static TransactionPhase fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionPhase fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
