// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionV0Envelope's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionV0Envelope
 * {
 *     TransactionV0 tx;
 *     /&#42; Each decorated signature is a signature over the SHA256 hash of
 *      &#42; a TransactionSignaturePayload &#42;/
 *     DecoratedSignature signatures&lt;20&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionV0Envelope implements XdrElement {
  private TransactionV0 tx;
  private DecoratedSignature[] signatures;

  public void encode(XdrDataOutputStream stream) throws IOException {
    tx.encode(stream);
    int signaturesSize = getSignatures().length;
    stream.writeInt(signaturesSize);
    for (int i = 0; i < signaturesSize; i++) {
      signatures[i].encode(stream);
    }
  }

  public static TransactionV0Envelope decode(XdrDataInputStream stream) throws IOException {
    TransactionV0Envelope decodedTransactionV0Envelope = new TransactionV0Envelope();
    decodedTransactionV0Envelope.tx = TransactionV0.decode(stream);
    int signaturesSize = stream.readInt();
    decodedTransactionV0Envelope.signatures = new DecoratedSignature[signaturesSize];
    for (int i = 0; i < signaturesSize; i++) {
      decodedTransactionV0Envelope.signatures[i] = DecoratedSignature.decode(stream);
    }
    return decodedTransactionV0Envelope;
  }

  public static TransactionV0Envelope fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionV0Envelope fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
