/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveOp;

public class PathPaymentStrictReceiveOperation
extends Operation {
    @NonNull
    private final Asset sendAsset;
    @NonNull
    private final BigDecimal sendMax;
    @NonNull
    private final String destination;
    @NonNull
    private final Asset destAsset;
    @NonNull
    private final BigDecimal destAmount;
    @NonNull
    private final Asset[] path;

    public static PathPaymentStrictReceiveOperation fromXdr(PathPaymentStrictReceiveOp op) {
        Asset sendAsset = Asset.fromXdr(op.getSendAsset());
        BigDecimal sendMax = Operation.fromXdrAmount(op.getSendMax().getInt64());
        String destination = MuxedAccount.fromXdr(op.getDestination()).getAddress();
        Asset destAsset = Asset.fromXdr(op.getDestAsset());
        BigDecimal destAmount = Operation.fromXdrAmount(op.getDestAmount().getInt64());
        Asset[] path = new Asset[op.getPath().length];
        for (int i = 0; i < op.getPath().length; ++i) {
            path[i] = Asset.fromXdr(op.getPath()[i]);
        }
        return new PathPaymentStrictReceiveOperation(sendAsset, sendMax, destination, destAsset, destAmount, path);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        PathPaymentStrictReceiveOp op = new PathPaymentStrictReceiveOp();
        op.setSendAsset(this.sendAsset.toXdr());
        Int64 sendMax = new Int64();
        sendMax.setInt64(Operation.toXdrAmount(this.sendMax));
        op.setSendMax(sendMax);
        op.setDestination(new MuxedAccount(this.destination).toXdr());
        op.setDestAsset(this.destAsset.toXdr());
        Int64 destAmount = new Int64();
        destAmount.setInt64(Operation.toXdrAmount(this.destAmount));
        op.setDestAmount(destAmount);
        org.stellar.sdk.xdr.Asset[] path = new org.stellar.sdk.xdr.Asset[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            path[i] = this.path[i].toXdr();
        }
        op.setPath(path);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PATH_PAYMENT_STRICT_RECEIVE);
        body.setPathPaymentStrictReceiveOp(op);
        return body;
    }

    @Generated
    private static Asset[] $default$path() {
        return new Asset[0];
    }

    @Generated
    protected PathPaymentStrictReceiveOperation(PathPaymentStrictReceiveOperationBuilder<?, ?> b) {
        super(b);
        this.sendAsset = ((PathPaymentStrictReceiveOperationBuilder)b).sendAsset;
        if (this.sendAsset == null) {
            throw new NullPointerException("sendAsset is marked non-null but is null");
        }
        this.sendMax = ((PathPaymentStrictReceiveOperationBuilder)b).sendMax;
        if (this.sendMax == null) {
            throw new NullPointerException("sendMax is marked non-null but is null");
        }
        this.destination = ((PathPaymentStrictReceiveOperationBuilder)b).destination;
        if (this.destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.destAsset = ((PathPaymentStrictReceiveOperationBuilder)b).destAsset;
        if (this.destAsset == null) {
            throw new NullPointerException("destAsset is marked non-null but is null");
        }
        this.destAmount = ((PathPaymentStrictReceiveOperationBuilder)b).destAmount;
        if (this.destAmount == null) {
            throw new NullPointerException("destAmount is marked non-null but is null");
        }
        this.path = ((PathPaymentStrictReceiveOperationBuilder)b).path$set ? ((PathPaymentStrictReceiveOperationBuilder)b).path$value : PathPaymentStrictReceiveOperation.$default$path();
        if (this.path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    @Generated
    public static PathPaymentStrictReceiveOperationBuilder<?, ?> builder() {
        return new PathPaymentStrictReceiveOperationBuilderImpl();
    }

    @Generated
    public PathPaymentStrictReceiveOperationBuilder<?, ?> toBuilder() {
        return new PathPaymentStrictReceiveOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public Asset getSendAsset() {
        return this.sendAsset;
    }

    @NonNull
    @Generated
    public BigDecimal getSendMax() {
        return this.sendMax;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Asset getDestAsset() {
        return this.destAsset;
    }

    @NonNull
    @Generated
    public BigDecimal getDestAmount() {
        return this.destAmount;
    }

    @NonNull
    @Generated
    public Asset[] getPath() {
        return this.path;
    }

    @Generated
    public String toString() {
        return "PathPaymentStrictReceiveOperation(super=" + super.toString() + ", sendAsset=" + this.getSendAsset() + ", sendMax=" + this.getSendMax() + ", destination=" + this.getDestination() + ", destAsset=" + this.getDestAsset() + ", destAmount=" + this.getDestAmount() + ", path=" + Arrays.deepToString(this.getPath()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictReceiveOperation)) {
            return false;
        }
        PathPaymentStrictReceiveOperation other = (PathPaymentStrictReceiveOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset this$sendAsset = this.getSendAsset();
        Asset other$sendAsset = other.getSendAsset();
        if (this$sendAsset == null ? other$sendAsset != null : !((Object)this$sendAsset).equals(other$sendAsset)) {
            return false;
        }
        BigDecimal this$sendMax = this.getSendMax();
        BigDecimal other$sendMax = other.getSendMax();
        if (this$sendMax == null ? other$sendMax != null : !((Object)this$sendMax).equals(other$sendMax)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Asset this$destAsset = this.getDestAsset();
        Asset other$destAsset = other.getDestAsset();
        if (this$destAsset == null ? other$destAsset != null : !((Object)this$destAsset).equals(other$destAsset)) {
            return false;
        }
        BigDecimal this$destAmount = this.getDestAmount();
        BigDecimal other$destAmount = other.getDestAmount();
        if (this$destAmount == null ? other$destAmount != null : !((Object)this$destAmount).equals(other$destAmount)) {
            return false;
        }
        return Arrays.deepEquals(this.getPath(), other.getPath());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictReceiveOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Asset $sendAsset = this.getSendAsset();
        result = result * 59 + ($sendAsset == null ? 43 : $sendAsset.hashCode());
        BigDecimal $sendMax = this.getSendMax();
        result = result * 59 + ($sendMax == null ? 43 : ((Object)$sendMax).hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Asset $destAsset = this.getDestAsset();
        result = result * 59 + ($destAsset == null ? 43 : $destAsset.hashCode());
        BigDecimal $destAmount = this.getDestAmount();
        result = result * 59 + ($destAmount == null ? 43 : ((Object)$destAmount).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        return result;
    }

    @Generated
    private PathPaymentStrictReceiveOperation(@NonNull Asset sendAsset, @NonNull BigDecimal sendMax, @NonNull String destination, @NonNull Asset destAsset, @NonNull BigDecimal destAmount, @NonNull Asset[] path) {
        if (sendAsset == null) {
            throw new NullPointerException("sendAsset is marked non-null but is null");
        }
        if (sendMax == null) {
            throw new NullPointerException("sendMax is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (destAsset == null) {
            throw new NullPointerException("destAsset is marked non-null but is null");
        }
        if (destAmount == null) {
            throw new NullPointerException("destAmount is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.sendAsset = sendAsset;
        this.sendMax = sendMax;
        this.destination = destination;
        this.destAsset = destAsset;
        this.destAmount = destAmount;
        this.path = path;
    }

    public static abstract class PathPaymentStrictReceiveOperationBuilder<C extends PathPaymentStrictReceiveOperation, B extends PathPaymentStrictReceiveOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private Asset sendAsset;
        @Generated
        private BigDecimal sendMax;
        @Generated
        private String destination;
        @Generated
        private Asset destAsset;
        @Generated
        private BigDecimal destAmount;
        @Generated
        private boolean path$set;
        @Generated
        private Asset[] path$value;

        public B sendMax(@NonNull BigDecimal sendMax) {
            if (sendMax == null) {
                throw new NullPointerException("sendMax is marked non-null but is null");
            }
            this.sendMax = sendMax;
            return (B)this.self();
        }

        public B destAmount(@NonNull BigDecimal destAmount) {
            if (destAmount == null) {
                throw new NullPointerException("destAmount is marked non-null but is null");
            }
            this.destAmount = destAmount;
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PathPaymentStrictReceiveOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PathPaymentStrictReceiveOperation instance, PathPaymentStrictReceiveOperationBuilder<?, ?> b) {
            b.sendAsset(instance.sendAsset);
            b.sendMax(instance.sendMax);
            b.destination(instance.destination);
            b.destAsset(instance.destAsset);
            b.destAmount(instance.destAmount);
            b.path(instance.path);
        }

        @Generated
        public B sendAsset(@NonNull Asset sendAsset) {
            if (sendAsset == null) {
                throw new NullPointerException("sendAsset is marked non-null but is null");
            }
            this.sendAsset = sendAsset;
            return (B)this.self();
        }

        @Generated
        public B destination(@NonNull String destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination = destination;
            return (B)this.self();
        }

        @Generated
        public B destAsset(@NonNull Asset destAsset) {
            if (destAsset == null) {
                throw new NullPointerException("destAsset is marked non-null but is null");
            }
            this.destAsset = destAsset;
            return (B)this.self();
        }

        @Generated
        public B path(@NonNull Asset[] path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path$value = path;
            this.path$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PathPaymentStrictReceiveOperation.PathPaymentStrictReceiveOperationBuilder(super=" + super.toString() + ", sendAsset=" + this.sendAsset + ", sendMax=" + this.sendMax + ", destination=" + this.destination + ", destAsset=" + this.destAsset + ", destAmount=" + this.destAmount + ", path$value=" + Arrays.deepToString(this.path$value) + ")";
        }
    }

    private static final class PathPaymentStrictReceiveOperationBuilderImpl
    extends PathPaymentStrictReceiveOperationBuilder<PathPaymentStrictReceiveOperation, PathPaymentStrictReceiveOperationBuilderImpl> {
        @Override
        public PathPaymentStrictReceiveOperation build() {
            PathPaymentStrictReceiveOperation op = new PathPaymentStrictReceiveOperation(this);
            if (op.path.length > 5) {
                throw new IllegalArgumentException("The maximum number of assets in the path is 5");
            }
            return op;
        }

        @Generated
        private PathPaymentStrictReceiveOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected PathPaymentStrictReceiveOperationBuilderImpl self() {
            return this;
        }
    }
}

