/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PaymentOp;

public class PaymentOperation
extends Operation {
    @NonNull
    private final String destination;
    @NonNull
    private final Asset asset;
    @NonNull
    private final BigDecimal amount;

    public static PaymentOperation fromXdr(PaymentOp op) {
        String destination = MuxedAccount.fromXdr(op.getDestination()).getAddress();
        Asset asset = Asset.fromXdr(op.getAsset());
        BigDecimal amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        return new PaymentOperation(destination, asset, amount);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        PaymentOp op = new PaymentOp();
        op.setDestination(new MuxedAccount(this.destination).toXdr());
        op.setAsset(this.asset.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PAYMENT);
        body.setPaymentOp(op);
        return body;
    }

    @Generated
    protected PaymentOperation(PaymentOperationBuilder<?, ?> b) {
        super(b);
        this.destination = ((PaymentOperationBuilder)b).destination;
        if (this.destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.asset = ((PaymentOperationBuilder)b).asset;
        if (this.asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.amount = ((PaymentOperationBuilder)b).amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
    }

    @Generated
    public static PaymentOperationBuilder<?, ?> builder() {
        return new PaymentOperationBuilderImpl();
    }

    @Generated
    public PaymentOperationBuilder<?, ?> toBuilder() {
        return new PaymentOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public String toString() {
        return "PaymentOperation(super=" + super.toString() + ", destination=" + this.getDestination() + ", asset=" + this.getAsset() + ", amount=" + this.getAmount() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentOperation)) {
            return false;
        }
        PaymentOperation other = (PaymentOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    private PaymentOperation(@NonNull String destination, @NonNull Asset asset, @NonNull BigDecimal amount) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.destination = destination;
        this.asset = asset;
        this.amount = amount;
    }

    @Generated
    private static final class PaymentOperationBuilderImpl
    extends PaymentOperationBuilder<PaymentOperation, PaymentOperationBuilderImpl> {
        @Generated
        private PaymentOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected PaymentOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PaymentOperation build() {
            return new PaymentOperation(this);
        }
    }

    public static abstract class PaymentOperationBuilder<C extends PaymentOperation, B extends PaymentOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String destination;
        @Generated
        private Asset asset;
        @Generated
        private BigDecimal amount;

        public B amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = Operation.formatAmountScale(amount);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PaymentOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PaymentOperation instance, PaymentOperationBuilder<?, ?> b) {
            b.destination(instance.destination);
            b.asset(instance.asset);
            b.amount(instance.amount);
        }

        @Generated
        public B destination(@NonNull String destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination = destination;
            return (B)this.self();
        }

        @Generated
        public B asset(@NonNull Asset asset) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            this.asset = asset;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PaymentOperation.PaymentOperationBuilder(super=" + super.toString() + ", destination=" + this.destination + ", asset=" + this.asset + ", amount=" + this.amount + ")";
        }
    }
}

