/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeClaimableBalanceSponsorshipOperation
extends Operation {
    @NonNull
    private final String balanceId;

    public static RevokeClaimableBalanceSponsorshipOperation fromXdr(RevokeSponsorshipOp op) {
        try {
            String balanceId = Util.bytesToHex(op.getLedgerKey().getClaimableBalance().getBalanceID().toXdrByteArray()).toLowerCase();
            return new RevokeClaimableBalanceSponsorshipOperation(balanceId);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid claimableBalance in the operation", e);
        }
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ClaimableBalanceID balanceId;
        byte[] balanceIdBytes = Util.hexToBytes(this.balanceId);
        try {
            balanceId = ClaimableBalanceID.fromXdrByteArray(balanceIdBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid balanceId: " + this.balanceId, e);
        }
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.CLAIMABLE_BALANCE);
        LedgerKey.LedgerKeyClaimableBalance claimableBalance = new LedgerKey.LedgerKeyClaimableBalance();
        claimableBalance.setBalanceID(balanceId);
        key.setClaimableBalance(claimableBalance);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @Generated
    protected RevokeClaimableBalanceSponsorshipOperation(RevokeClaimableBalanceSponsorshipOperationBuilder<?, ?> b) {
        super(b);
        this.balanceId = ((RevokeClaimableBalanceSponsorshipOperationBuilder)b).balanceId;
        if (this.balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
    }

    @Generated
    public static RevokeClaimableBalanceSponsorshipOperationBuilder<?, ?> builder() {
        return new RevokeClaimableBalanceSponsorshipOperationBuilderImpl();
    }

    @Generated
    public RevokeClaimableBalanceSponsorshipOperationBuilder<?, ?> toBuilder() {
        return new RevokeClaimableBalanceSponsorshipOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getBalanceId() {
        return this.balanceId;
    }

    @Generated
    public String toString() {
        return "RevokeClaimableBalanceSponsorshipOperation(super=" + super.toString() + ", balanceId=" + this.getBalanceId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeClaimableBalanceSponsorshipOperation)) {
            return false;
        }
        RevokeClaimableBalanceSponsorshipOperation other = (RevokeClaimableBalanceSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$balanceId = this.getBalanceId();
        String other$balanceId = other.getBalanceId();
        return !(this$balanceId == null ? other$balanceId != null : !this$balanceId.equals(other$balanceId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeClaimableBalanceSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $balanceId = this.getBalanceId();
        result = result * 59 + ($balanceId == null ? 43 : $balanceId.hashCode());
        return result;
    }

    @Generated
    private RevokeClaimableBalanceSponsorshipOperation(@NonNull String balanceId) {
        if (balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
        this.balanceId = balanceId;
    }

    @Generated
    private static final class RevokeClaimableBalanceSponsorshipOperationBuilderImpl
    extends RevokeClaimableBalanceSponsorshipOperationBuilder<RevokeClaimableBalanceSponsorshipOperation, RevokeClaimableBalanceSponsorshipOperationBuilderImpl> {
        @Generated
        private RevokeClaimableBalanceSponsorshipOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected RevokeClaimableBalanceSponsorshipOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RevokeClaimableBalanceSponsorshipOperation build() {
            return new RevokeClaimableBalanceSponsorshipOperation(this);
        }
    }

    public static abstract class RevokeClaimableBalanceSponsorshipOperationBuilder<C extends RevokeClaimableBalanceSponsorshipOperation, B extends RevokeClaimableBalanceSponsorshipOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String balanceId;

        public B balanceId(@NonNull String balanceId) {
            if (balanceId == null) {
                throw new NullPointerException("balanceId is marked non-null but is null");
            }
            if (balanceId.length() != 72) {
                throw new IllegalArgumentException("invalid balanceId: " + balanceId);
            }
            this.balanceId = balanceId.toLowerCase();
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RevokeClaimableBalanceSponsorshipOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RevokeClaimableBalanceSponsorshipOperation instance, RevokeClaimableBalanceSponsorshipOperationBuilder<?, ?> b) {
            b.balanceId(instance.balanceId);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RevokeClaimableBalanceSponsorshipOperation.RevokeClaimableBalanceSponsorshipOperationBuilder(super=" + super.toString() + ", balanceId=" + this.balanceId + ")";
        }
    }
}

