/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.BucketListType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class BucketMetadata
implements XdrElement {
    private Uint32 ledgerVersion;
    private BucketMetadataExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ledgerVersion.encode(stream);
        this.ext.encode(stream);
    }

    public static BucketMetadata decode(XdrDataInputStream stream) throws IOException {
        BucketMetadata decodedBucketMetadata = new BucketMetadata();
        decodedBucketMetadata.ledgerVersion = Uint32.decode(stream);
        decodedBucketMetadata.ext = BucketMetadataExt.decode(stream);
        return decodedBucketMetadata;
    }

    public static BucketMetadata fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BucketMetadata.fromXdrByteArray(bytes);
    }

    public static BucketMetadata fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BucketMetadata.decode(xdrDataInputStream);
    }

    @Generated
    public static BucketMetadataBuilder builder() {
        return new BucketMetadataBuilder();
    }

    @Generated
    public BucketMetadataBuilder toBuilder() {
        return new BucketMetadataBuilder().ledgerVersion(this.ledgerVersion).ext(this.ext);
    }

    @Generated
    public Uint32 getLedgerVersion() {
        return this.ledgerVersion;
    }

    @Generated
    public BucketMetadataExt getExt() {
        return this.ext;
    }

    @Generated
    public void setLedgerVersion(Uint32 ledgerVersion) {
        this.ledgerVersion = ledgerVersion;
    }

    @Generated
    public void setExt(BucketMetadataExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketMetadata)) {
            return false;
        }
        BucketMetadata other = (BucketMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$ledgerVersion = this.getLedgerVersion();
        Uint32 other$ledgerVersion = other.getLedgerVersion();
        if (this$ledgerVersion == null ? other$ledgerVersion != null : !((Object)this$ledgerVersion).equals(other$ledgerVersion)) {
            return false;
        }
        BucketMetadataExt this$ext = this.getExt();
        BucketMetadataExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BucketMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $ledgerVersion = this.getLedgerVersion();
        result = result * 59 + ($ledgerVersion == null ? 43 : ((Object)$ledgerVersion).hashCode());
        BucketMetadataExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BucketMetadata(ledgerVersion=" + this.getLedgerVersion() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public BucketMetadata() {
    }

    @Generated
    public BucketMetadata(Uint32 ledgerVersion, BucketMetadataExt ext) {
        this.ledgerVersion = ledgerVersion;
        this.ext = ext;
    }

    @Generated
    public static class BucketMetadataBuilder {
        @Generated
        private Uint32 ledgerVersion;
        @Generated
        private BucketMetadataExt ext;

        @Generated
        BucketMetadataBuilder() {
        }

        @Generated
        public BucketMetadataBuilder ledgerVersion(Uint32 ledgerVersion) {
            this.ledgerVersion = ledgerVersion;
            return this;
        }

        @Generated
        public BucketMetadataBuilder ext(BucketMetadataExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public BucketMetadata build() {
            return new BucketMetadata(this.ledgerVersion, this.ext);
        }

        @Generated
        public String toString() {
            return "BucketMetadata.BucketMetadataBuilder(ledgerVersion=" + this.ledgerVersion + ", ext=" + this.ext + ")";
        }
    }

    public static class BucketMetadataExt
    implements XdrElement {
        private Integer discriminant;
        private BucketListType bucketListType;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.bucketListType.encode(stream);
                }
            }
        }

        public static BucketMetadataExt decode(XdrDataInputStream stream) throws IOException {
            BucketMetadataExt decodedBucketMetadataExt = new BucketMetadataExt();
            Integer discriminant = stream.readInt();
            decodedBucketMetadataExt.setDiscriminant(discriminant);
            switch (decodedBucketMetadataExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedBucketMetadataExt.bucketListType = BucketListType.decode(stream);
                }
            }
            return decodedBucketMetadataExt;
        }

        public static BucketMetadataExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return BucketMetadataExt.fromXdrByteArray(bytes);
        }

        public static BucketMetadataExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return BucketMetadataExt.decode(xdrDataInputStream);
        }

        @Generated
        public static BucketMetadataExtBuilder builder() {
            return new BucketMetadataExtBuilder();
        }

        @Generated
        public BucketMetadataExtBuilder toBuilder() {
            return new BucketMetadataExtBuilder().discriminant(this.discriminant).bucketListType(this.bucketListType);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public BucketListType getBucketListType() {
            return this.bucketListType;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setBucketListType(BucketListType bucketListType) {
            this.bucketListType = bucketListType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BucketMetadataExt)) {
                return false;
            }
            BucketMetadataExt other = (BucketMetadataExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            BucketListType this$bucketListType = this.getBucketListType();
            BucketListType other$bucketListType = other.getBucketListType();
            return !(this$bucketListType == null ? other$bucketListType != null : !this$bucketListType.equals(other$bucketListType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BucketMetadataExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            BucketListType $bucketListType = this.getBucketListType();
            result = result * 59 + ($bucketListType == null ? 43 : $bucketListType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BucketMetadata.BucketMetadataExt(discriminant=" + this.getDiscriminant() + ", bucketListType=" + this.getBucketListType() + ")";
        }

        @Generated
        public BucketMetadataExt() {
        }

        @Generated
        public BucketMetadataExt(Integer discriminant, BucketListType bucketListType) {
            this.discriminant = discriminant;
            this.bucketListType = bucketListType;
        }

        @Generated
        public static class BucketMetadataExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private BucketListType bucketListType;

            @Generated
            BucketMetadataExtBuilder() {
            }

            @Generated
            public BucketMetadataExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public BucketMetadataExtBuilder bucketListType(BucketListType bucketListType) {
                this.bucketListType = bucketListType;
                return this;
            }

            @Generated
            public BucketMetadataExt build() {
                return new BucketMetadataExt(this.discriminant, this.bucketListType);
            }

            @Generated
            public String toString() {
                return "BucketMetadata.BucketMetadataExt.BucketMetadataExtBuilder(discriminant=" + this.discriminant + ", bucketListType=" + this.bucketListType + ")";
            }
        }
    }
}

