/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LedgerHeader;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerHeaderHistoryEntry
implements XdrElement {
    private Hash hash;
    private LedgerHeader header;
    private LedgerHeaderHistoryEntryExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.hash.encode(stream);
        this.header.encode(stream);
        this.ext.encode(stream);
    }

    public static LedgerHeaderHistoryEntry decode(XdrDataInputStream stream) throws IOException {
        LedgerHeaderHistoryEntry decodedLedgerHeaderHistoryEntry = new LedgerHeaderHistoryEntry();
        decodedLedgerHeaderHistoryEntry.hash = Hash.decode(stream);
        decodedLedgerHeaderHistoryEntry.header = LedgerHeader.decode(stream);
        decodedLedgerHeaderHistoryEntry.ext = LedgerHeaderHistoryEntryExt.decode(stream);
        return decodedLedgerHeaderHistoryEntry;
    }

    public static LedgerHeaderHistoryEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerHeaderHistoryEntry.fromXdrByteArray(bytes);
    }

    public static LedgerHeaderHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerHeaderHistoryEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerHeaderHistoryEntryBuilder builder() {
        return new LedgerHeaderHistoryEntryBuilder();
    }

    @Generated
    public LedgerHeaderHistoryEntryBuilder toBuilder() {
        return new LedgerHeaderHistoryEntryBuilder().hash(this.hash).header(this.header).ext(this.ext);
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public LedgerHeader getHeader() {
        return this.header;
    }

    @Generated
    public LedgerHeaderHistoryEntryExt getExt() {
        return this.ext;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public void setHeader(LedgerHeader header) {
        this.header = header;
    }

    @Generated
    public void setExt(LedgerHeaderHistoryEntryExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerHeaderHistoryEntry)) {
            return false;
        }
        LedgerHeaderHistoryEntry other = (LedgerHeaderHistoryEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        LedgerHeader this$header = this.getHeader();
        LedgerHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        LedgerHeaderHistoryEntryExt this$ext = this.getExt();
        LedgerHeaderHistoryEntryExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerHeaderHistoryEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        LedgerHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        LedgerHeaderHistoryEntryExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerHeaderHistoryEntry(hash=" + this.getHash() + ", header=" + this.getHeader() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public LedgerHeaderHistoryEntry() {
    }

    @Generated
    public LedgerHeaderHistoryEntry(Hash hash, LedgerHeader header, LedgerHeaderHistoryEntryExt ext) {
        this.hash = hash;
        this.header = header;
        this.ext = ext;
    }

    @Generated
    public static class LedgerHeaderHistoryEntryBuilder {
        @Generated
        private Hash hash;
        @Generated
        private LedgerHeader header;
        @Generated
        private LedgerHeaderHistoryEntryExt ext;

        @Generated
        LedgerHeaderHistoryEntryBuilder() {
        }

        @Generated
        public LedgerHeaderHistoryEntryBuilder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        @Generated
        public LedgerHeaderHistoryEntryBuilder header(LedgerHeader header) {
            this.header = header;
            return this;
        }

        @Generated
        public LedgerHeaderHistoryEntryBuilder ext(LedgerHeaderHistoryEntryExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public LedgerHeaderHistoryEntry build() {
            return new LedgerHeaderHistoryEntry(this.hash, this.header, this.ext);
        }

        @Generated
        public String toString() {
            return "LedgerHeaderHistoryEntry.LedgerHeaderHistoryEntryBuilder(hash=" + this.hash + ", header=" + this.header + ", ext=" + this.ext + ")";
        }
    }

    public static class LedgerHeaderHistoryEntryExt
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static LedgerHeaderHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
            LedgerHeaderHistoryEntryExt decodedLedgerHeaderHistoryEntryExt = new LedgerHeaderHistoryEntryExt();
            Integer discriminant = stream.readInt();
            decodedLedgerHeaderHistoryEntryExt.setDiscriminant(discriminant);
            switch (decodedLedgerHeaderHistoryEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedLedgerHeaderHistoryEntryExt;
        }

        public static LedgerHeaderHistoryEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerHeaderHistoryEntryExt.fromXdrByteArray(bytes);
        }

        public static LedgerHeaderHistoryEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerHeaderHistoryEntryExt.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerHeaderHistoryEntryExtBuilder builder() {
            return new LedgerHeaderHistoryEntryExtBuilder();
        }

        @Generated
        public LedgerHeaderHistoryEntryExtBuilder toBuilder() {
            return new LedgerHeaderHistoryEntryExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerHeaderHistoryEntryExt)) {
                return false;
            }
            LedgerHeaderHistoryEntryExt other = (LedgerHeaderHistoryEntryExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerHeaderHistoryEntryExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerHeaderHistoryEntry.LedgerHeaderHistoryEntryExt(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public LedgerHeaderHistoryEntryExt() {
        }

        @Generated
        public LedgerHeaderHistoryEntryExt(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class LedgerHeaderHistoryEntryExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            LedgerHeaderHistoryEntryExtBuilder() {
            }

            @Generated
            public LedgerHeaderHistoryEntryExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public LedgerHeaderHistoryEntryExt build() {
                return new LedgerHeaderHistoryEntryExt(this.discriminant);
            }

            @Generated
            public String toString() {
                return "LedgerHeaderHistoryEntry.LedgerHeaderHistoryEntryExt.LedgerHeaderHistoryEntryExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }
}

