/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ConfigSettingID;
import org.stellar.sdk.xdr.ContractDataDurability;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.TrustLineAsset;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerKey
implements XdrElement {
    private LedgerEntryType discriminant;
    private LedgerKeyAccount account;
    private LedgerKeyTrustLine trustLine;
    private LedgerKeyOffer offer;
    private LedgerKeyData data;
    private LedgerKeyClaimableBalance claimableBalance;
    private LedgerKeyLiquidityPool liquidityPool;
    private LedgerKeyContractData contractData;
    private LedgerKeyContractCode contractCode;
    private LedgerKeyConfigSetting configSetting;
    private LedgerKeyTtl ttl;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ACCOUNT: {
                this.account.encode(stream);
                break;
            }
            case TRUSTLINE: {
                this.trustLine.encode(stream);
                break;
            }
            case OFFER: {
                this.offer.encode(stream);
                break;
            }
            case DATA: {
                this.data.encode(stream);
                break;
            }
            case CLAIMABLE_BALANCE: {
                this.claimableBalance.encode(stream);
                break;
            }
            case LIQUIDITY_POOL: {
                this.liquidityPool.encode(stream);
                break;
            }
            case CONTRACT_DATA: {
                this.contractData.encode(stream);
                break;
            }
            case CONTRACT_CODE: {
                this.contractCode.encode(stream);
                break;
            }
            case CONFIG_SETTING: {
                this.configSetting.encode(stream);
                break;
            }
            case TTL: {
                this.ttl.encode(stream);
            }
        }
    }

    public static LedgerKey decode(XdrDataInputStream stream) throws IOException {
        LedgerKey decodedLedgerKey = new LedgerKey();
        LedgerEntryType discriminant = LedgerEntryType.decode(stream);
        decodedLedgerKey.setDiscriminant(discriminant);
        switch (decodedLedgerKey.getDiscriminant()) {
            case ACCOUNT: {
                decodedLedgerKey.account = LedgerKeyAccount.decode(stream);
                break;
            }
            case TRUSTLINE: {
                decodedLedgerKey.trustLine = LedgerKeyTrustLine.decode(stream);
                break;
            }
            case OFFER: {
                decodedLedgerKey.offer = LedgerKeyOffer.decode(stream);
                break;
            }
            case DATA: {
                decodedLedgerKey.data = LedgerKeyData.decode(stream);
                break;
            }
            case CLAIMABLE_BALANCE: {
                decodedLedgerKey.claimableBalance = LedgerKeyClaimableBalance.decode(stream);
                break;
            }
            case LIQUIDITY_POOL: {
                decodedLedgerKey.liquidityPool = LedgerKeyLiquidityPool.decode(stream);
                break;
            }
            case CONTRACT_DATA: {
                decodedLedgerKey.contractData = LedgerKeyContractData.decode(stream);
                break;
            }
            case CONTRACT_CODE: {
                decodedLedgerKey.contractCode = LedgerKeyContractCode.decode(stream);
                break;
            }
            case CONFIG_SETTING: {
                decodedLedgerKey.configSetting = LedgerKeyConfigSetting.decode(stream);
                break;
            }
            case TTL: {
                decodedLedgerKey.ttl = LedgerKeyTtl.decode(stream);
            }
        }
        return decodedLedgerKey;
    }

    public static LedgerKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerKey.fromXdrByteArray(bytes);
    }

    public static LedgerKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerKey.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerKeyBuilder builder() {
        return new LedgerKeyBuilder();
    }

    @Generated
    public LedgerKeyBuilder toBuilder() {
        return new LedgerKeyBuilder().discriminant(this.discriminant).account(this.account).trustLine(this.trustLine).offer(this.offer).data(this.data).claimableBalance(this.claimableBalance).liquidityPool(this.liquidityPool).contractData(this.contractData).contractCode(this.contractCode).configSetting(this.configSetting).ttl(this.ttl);
    }

    @Generated
    public LedgerEntryType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public LedgerKeyAccount getAccount() {
        return this.account;
    }

    @Generated
    public LedgerKeyTrustLine getTrustLine() {
        return this.trustLine;
    }

    @Generated
    public LedgerKeyOffer getOffer() {
        return this.offer;
    }

    @Generated
    public LedgerKeyData getData() {
        return this.data;
    }

    @Generated
    public LedgerKeyClaimableBalance getClaimableBalance() {
        return this.claimableBalance;
    }

    @Generated
    public LedgerKeyLiquidityPool getLiquidityPool() {
        return this.liquidityPool;
    }

    @Generated
    public LedgerKeyContractData getContractData() {
        return this.contractData;
    }

    @Generated
    public LedgerKeyContractCode getContractCode() {
        return this.contractCode;
    }

    @Generated
    public LedgerKeyConfigSetting getConfigSetting() {
        return this.configSetting;
    }

    @Generated
    public LedgerKeyTtl getTtl() {
        return this.ttl;
    }

    @Generated
    public void setDiscriminant(LedgerEntryType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAccount(LedgerKeyAccount account) {
        this.account = account;
    }

    @Generated
    public void setTrustLine(LedgerKeyTrustLine trustLine) {
        this.trustLine = trustLine;
    }

    @Generated
    public void setOffer(LedgerKeyOffer offer) {
        this.offer = offer;
    }

    @Generated
    public void setData(LedgerKeyData data) {
        this.data = data;
    }

    @Generated
    public void setClaimableBalance(LedgerKeyClaimableBalance claimableBalance) {
        this.claimableBalance = claimableBalance;
    }

    @Generated
    public void setLiquidityPool(LedgerKeyLiquidityPool liquidityPool) {
        this.liquidityPool = liquidityPool;
    }

    @Generated
    public void setContractData(LedgerKeyContractData contractData) {
        this.contractData = contractData;
    }

    @Generated
    public void setContractCode(LedgerKeyContractCode contractCode) {
        this.contractCode = contractCode;
    }

    @Generated
    public void setConfigSetting(LedgerKeyConfigSetting configSetting) {
        this.configSetting = configSetting;
    }

    @Generated
    public void setTtl(LedgerKeyTtl ttl) {
        this.ttl = ttl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerKey)) {
            return false;
        }
        LedgerKey other = (LedgerKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerEntryType this$discriminant = this.getDiscriminant();
        LedgerEntryType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        LedgerKeyAccount this$account = this.getAccount();
        LedgerKeyAccount other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        LedgerKeyTrustLine this$trustLine = this.getTrustLine();
        LedgerKeyTrustLine other$trustLine = other.getTrustLine();
        if (this$trustLine == null ? other$trustLine != null : !((Object)this$trustLine).equals(other$trustLine)) {
            return false;
        }
        LedgerKeyOffer this$offer = this.getOffer();
        LedgerKeyOffer other$offer = other.getOffer();
        if (this$offer == null ? other$offer != null : !((Object)this$offer).equals(other$offer)) {
            return false;
        }
        LedgerKeyData this$data = this.getData();
        LedgerKeyData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        LedgerKeyClaimableBalance this$claimableBalance = this.getClaimableBalance();
        LedgerKeyClaimableBalance other$claimableBalance = other.getClaimableBalance();
        if (this$claimableBalance == null ? other$claimableBalance != null : !((Object)this$claimableBalance).equals(other$claimableBalance)) {
            return false;
        }
        LedgerKeyLiquidityPool this$liquidityPool = this.getLiquidityPool();
        LedgerKeyLiquidityPool other$liquidityPool = other.getLiquidityPool();
        if (this$liquidityPool == null ? other$liquidityPool != null : !((Object)this$liquidityPool).equals(other$liquidityPool)) {
            return false;
        }
        LedgerKeyContractData this$contractData = this.getContractData();
        LedgerKeyContractData other$contractData = other.getContractData();
        if (this$contractData == null ? other$contractData != null : !((Object)this$contractData).equals(other$contractData)) {
            return false;
        }
        LedgerKeyContractCode this$contractCode = this.getContractCode();
        LedgerKeyContractCode other$contractCode = other.getContractCode();
        if (this$contractCode == null ? other$contractCode != null : !((Object)this$contractCode).equals(other$contractCode)) {
            return false;
        }
        LedgerKeyConfigSetting this$configSetting = this.getConfigSetting();
        LedgerKeyConfigSetting other$configSetting = other.getConfigSetting();
        if (this$configSetting == null ? other$configSetting != null : !((Object)this$configSetting).equals(other$configSetting)) {
            return false;
        }
        LedgerKeyTtl this$ttl = this.getTtl();
        LedgerKeyTtl other$ttl = other.getTtl();
        return !(this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerEntryType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        LedgerKeyAccount $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        LedgerKeyTrustLine $trustLine = this.getTrustLine();
        result = result * 59 + ($trustLine == null ? 43 : ((Object)$trustLine).hashCode());
        LedgerKeyOffer $offer = this.getOffer();
        result = result * 59 + ($offer == null ? 43 : ((Object)$offer).hashCode());
        LedgerKeyData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        LedgerKeyClaimableBalance $claimableBalance = this.getClaimableBalance();
        result = result * 59 + ($claimableBalance == null ? 43 : ((Object)$claimableBalance).hashCode());
        LedgerKeyLiquidityPool $liquidityPool = this.getLiquidityPool();
        result = result * 59 + ($liquidityPool == null ? 43 : ((Object)$liquidityPool).hashCode());
        LedgerKeyContractData $contractData = this.getContractData();
        result = result * 59 + ($contractData == null ? 43 : ((Object)$contractData).hashCode());
        LedgerKeyContractCode $contractCode = this.getContractCode();
        result = result * 59 + ($contractCode == null ? 43 : ((Object)$contractCode).hashCode());
        LedgerKeyConfigSetting $configSetting = this.getConfigSetting();
        result = result * 59 + ($configSetting == null ? 43 : ((Object)$configSetting).hashCode());
        LedgerKeyTtl $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerKey(discriminant=" + this.getDiscriminant() + ", account=" + this.getAccount() + ", trustLine=" + this.getTrustLine() + ", offer=" + this.getOffer() + ", data=" + this.getData() + ", claimableBalance=" + this.getClaimableBalance() + ", liquidityPool=" + this.getLiquidityPool() + ", contractData=" + this.getContractData() + ", contractCode=" + this.getContractCode() + ", configSetting=" + this.getConfigSetting() + ", ttl=" + this.getTtl() + ")";
    }

    @Generated
    public LedgerKey() {
    }

    @Generated
    public LedgerKey(LedgerEntryType discriminant, LedgerKeyAccount account, LedgerKeyTrustLine trustLine, LedgerKeyOffer offer, LedgerKeyData data, LedgerKeyClaimableBalance claimableBalance, LedgerKeyLiquidityPool liquidityPool, LedgerKeyContractData contractData, LedgerKeyContractCode contractCode, LedgerKeyConfigSetting configSetting, LedgerKeyTtl ttl) {
        this.discriminant = discriminant;
        this.account = account;
        this.trustLine = trustLine;
        this.offer = offer;
        this.data = data;
        this.claimableBalance = claimableBalance;
        this.liquidityPool = liquidityPool;
        this.contractData = contractData;
        this.contractCode = contractCode;
        this.configSetting = configSetting;
        this.ttl = ttl;
    }

    @Generated
    public static class LedgerKeyBuilder {
        @Generated
        private LedgerEntryType discriminant;
        @Generated
        private LedgerKeyAccount account;
        @Generated
        private LedgerKeyTrustLine trustLine;
        @Generated
        private LedgerKeyOffer offer;
        @Generated
        private LedgerKeyData data;
        @Generated
        private LedgerKeyClaimableBalance claimableBalance;
        @Generated
        private LedgerKeyLiquidityPool liquidityPool;
        @Generated
        private LedgerKeyContractData contractData;
        @Generated
        private LedgerKeyContractCode contractCode;
        @Generated
        private LedgerKeyConfigSetting configSetting;
        @Generated
        private LedgerKeyTtl ttl;

        @Generated
        LedgerKeyBuilder() {
        }

        @Generated
        public LedgerKeyBuilder discriminant(LedgerEntryType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public LedgerKeyBuilder account(LedgerKeyAccount account) {
            this.account = account;
            return this;
        }

        @Generated
        public LedgerKeyBuilder trustLine(LedgerKeyTrustLine trustLine) {
            this.trustLine = trustLine;
            return this;
        }

        @Generated
        public LedgerKeyBuilder offer(LedgerKeyOffer offer) {
            this.offer = offer;
            return this;
        }

        @Generated
        public LedgerKeyBuilder data(LedgerKeyData data) {
            this.data = data;
            return this;
        }

        @Generated
        public LedgerKeyBuilder claimableBalance(LedgerKeyClaimableBalance claimableBalance) {
            this.claimableBalance = claimableBalance;
            return this;
        }

        @Generated
        public LedgerKeyBuilder liquidityPool(LedgerKeyLiquidityPool liquidityPool) {
            this.liquidityPool = liquidityPool;
            return this;
        }

        @Generated
        public LedgerKeyBuilder contractData(LedgerKeyContractData contractData) {
            this.contractData = contractData;
            return this;
        }

        @Generated
        public LedgerKeyBuilder contractCode(LedgerKeyContractCode contractCode) {
            this.contractCode = contractCode;
            return this;
        }

        @Generated
        public LedgerKeyBuilder configSetting(LedgerKeyConfigSetting configSetting) {
            this.configSetting = configSetting;
            return this;
        }

        @Generated
        public LedgerKeyBuilder ttl(LedgerKeyTtl ttl) {
            this.ttl = ttl;
            return this;
        }

        @Generated
        public LedgerKey build() {
            return new LedgerKey(this.discriminant, this.account, this.trustLine, this.offer, this.data, this.claimableBalance, this.liquidityPool, this.contractData, this.contractCode, this.configSetting, this.ttl);
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyBuilder(discriminant=" + this.discriminant + ", account=" + this.account + ", trustLine=" + this.trustLine + ", offer=" + this.offer + ", data=" + this.data + ", claimableBalance=" + this.claimableBalance + ", liquidityPool=" + this.liquidityPool + ", contractData=" + this.contractData + ", contractCode=" + this.contractCode + ", configSetting=" + this.configSetting + ", ttl=" + this.ttl + ")";
        }
    }

    public static class LedgerKeyTtl
    implements XdrElement {
        private Hash keyHash;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.keyHash.encode(stream);
        }

        public static LedgerKeyTtl decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyTtl decodedLedgerKeyTtl = new LedgerKeyTtl();
            decodedLedgerKeyTtl.keyHash = Hash.decode(stream);
            return decodedLedgerKeyTtl;
        }

        public static LedgerKeyTtl fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyTtl.fromXdrByteArray(bytes);
        }

        public static LedgerKeyTtl fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyTtl.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyTtlBuilder builder() {
            return new LedgerKeyTtlBuilder();
        }

        @Generated
        public LedgerKeyTtlBuilder toBuilder() {
            return new LedgerKeyTtlBuilder().keyHash(this.keyHash);
        }

        @Generated
        public Hash getKeyHash() {
            return this.keyHash;
        }

        @Generated
        public void setKeyHash(Hash keyHash) {
            this.keyHash = keyHash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyTtl)) {
                return false;
            }
            LedgerKeyTtl other = (LedgerKeyTtl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Hash this$keyHash = this.getKeyHash();
            Hash other$keyHash = other.getKeyHash();
            return !(this$keyHash == null ? other$keyHash != null : !((Object)this$keyHash).equals(other$keyHash));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyTtl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Hash $keyHash = this.getKeyHash();
            result = result * 59 + ($keyHash == null ? 43 : ((Object)$keyHash).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyTtl(keyHash=" + this.getKeyHash() + ")";
        }

        @Generated
        public LedgerKeyTtl() {
        }

        @Generated
        public LedgerKeyTtl(Hash keyHash) {
            this.keyHash = keyHash;
        }

        @Generated
        public static class LedgerKeyTtlBuilder {
            @Generated
            private Hash keyHash;

            @Generated
            LedgerKeyTtlBuilder() {
            }

            @Generated
            public LedgerKeyTtlBuilder keyHash(Hash keyHash) {
                this.keyHash = keyHash;
                return this;
            }

            @Generated
            public LedgerKeyTtl build() {
                return new LedgerKeyTtl(this.keyHash);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyTtl.LedgerKeyTtlBuilder(keyHash=" + this.keyHash + ")";
            }
        }
    }

    public static class LedgerKeyConfigSetting
    implements XdrElement {
        private ConfigSettingID configSettingID;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.configSettingID.encode(stream);
        }

        public static LedgerKeyConfigSetting decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyConfigSetting decodedLedgerKeyConfigSetting = new LedgerKeyConfigSetting();
            decodedLedgerKeyConfigSetting.configSettingID = ConfigSettingID.decode(stream);
            return decodedLedgerKeyConfigSetting;
        }

        public static LedgerKeyConfigSetting fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyConfigSetting.fromXdrByteArray(bytes);
        }

        public static LedgerKeyConfigSetting fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyConfigSetting.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyConfigSettingBuilder builder() {
            return new LedgerKeyConfigSettingBuilder();
        }

        @Generated
        public LedgerKeyConfigSettingBuilder toBuilder() {
            return new LedgerKeyConfigSettingBuilder().configSettingID(this.configSettingID);
        }

        @Generated
        public ConfigSettingID getConfigSettingID() {
            return this.configSettingID;
        }

        @Generated
        public void setConfigSettingID(ConfigSettingID configSettingID) {
            this.configSettingID = configSettingID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyConfigSetting)) {
                return false;
            }
            LedgerKeyConfigSetting other = (LedgerKeyConfigSetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ConfigSettingID this$configSettingID = this.getConfigSettingID();
            ConfigSettingID other$configSettingID = other.getConfigSettingID();
            return !(this$configSettingID == null ? other$configSettingID != null : !this$configSettingID.equals(other$configSettingID));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyConfigSetting;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ConfigSettingID $configSettingID = this.getConfigSettingID();
            result = result * 59 + ($configSettingID == null ? 43 : $configSettingID.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyConfigSetting(configSettingID=" + this.getConfigSettingID() + ")";
        }

        @Generated
        public LedgerKeyConfigSetting() {
        }

        @Generated
        public LedgerKeyConfigSetting(ConfigSettingID configSettingID) {
            this.configSettingID = configSettingID;
        }

        @Generated
        public static class LedgerKeyConfigSettingBuilder {
            @Generated
            private ConfigSettingID configSettingID;

            @Generated
            LedgerKeyConfigSettingBuilder() {
            }

            @Generated
            public LedgerKeyConfigSettingBuilder configSettingID(ConfigSettingID configSettingID) {
                this.configSettingID = configSettingID;
                return this;
            }

            @Generated
            public LedgerKeyConfigSetting build() {
                return new LedgerKeyConfigSetting(this.configSettingID);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyConfigSetting.LedgerKeyConfigSettingBuilder(configSettingID=" + this.configSettingID + ")";
            }
        }
    }

    public static class LedgerKeyContractCode
    implements XdrElement {
        private Hash hash;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.hash.encode(stream);
        }

        public static LedgerKeyContractCode decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyContractCode decodedLedgerKeyContractCode = new LedgerKeyContractCode();
            decodedLedgerKeyContractCode.hash = Hash.decode(stream);
            return decodedLedgerKeyContractCode;
        }

        public static LedgerKeyContractCode fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyContractCode.fromXdrByteArray(bytes);
        }

        public static LedgerKeyContractCode fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyContractCode.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyContractCodeBuilder builder() {
            return new LedgerKeyContractCodeBuilder();
        }

        @Generated
        public LedgerKeyContractCodeBuilder toBuilder() {
            return new LedgerKeyContractCodeBuilder().hash(this.hash);
        }

        @Generated
        public Hash getHash() {
            return this.hash;
        }

        @Generated
        public void setHash(Hash hash) {
            this.hash = hash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyContractCode)) {
                return false;
            }
            LedgerKeyContractCode other = (LedgerKeyContractCode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Hash this$hash = this.getHash();
            Hash other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyContractCode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Hash $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyContractCode(hash=" + this.getHash() + ")";
        }

        @Generated
        public LedgerKeyContractCode() {
        }

        @Generated
        public LedgerKeyContractCode(Hash hash) {
            this.hash = hash;
        }

        @Generated
        public static class LedgerKeyContractCodeBuilder {
            @Generated
            private Hash hash;

            @Generated
            LedgerKeyContractCodeBuilder() {
            }

            @Generated
            public LedgerKeyContractCodeBuilder hash(Hash hash) {
                this.hash = hash;
                return this;
            }

            @Generated
            public LedgerKeyContractCode build() {
                return new LedgerKeyContractCode(this.hash);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyContractCode.LedgerKeyContractCodeBuilder(hash=" + this.hash + ")";
            }
        }
    }

    public static class LedgerKeyContractData
    implements XdrElement {
        private SCAddress contract;
        private SCVal key;
        private ContractDataDurability durability;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.contract.encode(stream);
            this.key.encode(stream);
            this.durability.encode(stream);
        }

        public static LedgerKeyContractData decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyContractData decodedLedgerKeyContractData = new LedgerKeyContractData();
            decodedLedgerKeyContractData.contract = SCAddress.decode(stream);
            decodedLedgerKeyContractData.key = SCVal.decode(stream);
            decodedLedgerKeyContractData.durability = ContractDataDurability.decode(stream);
            return decodedLedgerKeyContractData;
        }

        public static LedgerKeyContractData fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyContractData.fromXdrByteArray(bytes);
        }

        public static LedgerKeyContractData fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyContractData.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyContractDataBuilder builder() {
            return new LedgerKeyContractDataBuilder();
        }

        @Generated
        public LedgerKeyContractDataBuilder toBuilder() {
            return new LedgerKeyContractDataBuilder().contract(this.contract).key(this.key).durability(this.durability);
        }

        @Generated
        public SCAddress getContract() {
            return this.contract;
        }

        @Generated
        public SCVal getKey() {
            return this.key;
        }

        @Generated
        public ContractDataDurability getDurability() {
            return this.durability;
        }

        @Generated
        public void setContract(SCAddress contract) {
            this.contract = contract;
        }

        @Generated
        public void setKey(SCVal key) {
            this.key = key;
        }

        @Generated
        public void setDurability(ContractDataDurability durability) {
            this.durability = durability;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyContractData)) {
                return false;
            }
            LedgerKeyContractData other = (LedgerKeyContractData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SCAddress this$contract = this.getContract();
            SCAddress other$contract = other.getContract();
            if (this$contract == null ? other$contract != null : !((Object)this$contract).equals(other$contract)) {
                return false;
            }
            SCVal this$key = this.getKey();
            SCVal other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            ContractDataDurability this$durability = this.getDurability();
            ContractDataDurability other$durability = other.getDurability();
            return !(this$durability == null ? other$durability != null : !this$durability.equals(other$durability));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyContractData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SCAddress $contract = this.getContract();
            result = result * 59 + ($contract == null ? 43 : ((Object)$contract).hashCode());
            SCVal $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            ContractDataDurability $durability = this.getDurability();
            result = result * 59 + ($durability == null ? 43 : $durability.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyContractData(contract=" + this.getContract() + ", key=" + this.getKey() + ", durability=" + this.getDurability() + ")";
        }

        @Generated
        public LedgerKeyContractData() {
        }

        @Generated
        public LedgerKeyContractData(SCAddress contract, SCVal key, ContractDataDurability durability) {
            this.contract = contract;
            this.key = key;
            this.durability = durability;
        }

        @Generated
        public static class LedgerKeyContractDataBuilder {
            @Generated
            private SCAddress contract;
            @Generated
            private SCVal key;
            @Generated
            private ContractDataDurability durability;

            @Generated
            LedgerKeyContractDataBuilder() {
            }

            @Generated
            public LedgerKeyContractDataBuilder contract(SCAddress contract) {
                this.contract = contract;
                return this;
            }

            @Generated
            public LedgerKeyContractDataBuilder key(SCVal key) {
                this.key = key;
                return this;
            }

            @Generated
            public LedgerKeyContractDataBuilder durability(ContractDataDurability durability) {
                this.durability = durability;
                return this;
            }

            @Generated
            public LedgerKeyContractData build() {
                return new LedgerKeyContractData(this.contract, this.key, this.durability);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyContractData.LedgerKeyContractDataBuilder(contract=" + this.contract + ", key=" + this.key + ", durability=" + this.durability + ")";
            }
        }
    }

    public static class LedgerKeyLiquidityPool
    implements XdrElement {
        private PoolID liquidityPoolID;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.liquidityPoolID.encode(stream);
        }

        public static LedgerKeyLiquidityPool decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyLiquidityPool decodedLedgerKeyLiquidityPool = new LedgerKeyLiquidityPool();
            decodedLedgerKeyLiquidityPool.liquidityPoolID = PoolID.decode(stream);
            return decodedLedgerKeyLiquidityPool;
        }

        public static LedgerKeyLiquidityPool fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyLiquidityPool.fromXdrByteArray(bytes);
        }

        public static LedgerKeyLiquidityPool fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyLiquidityPool.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyLiquidityPoolBuilder builder() {
            return new LedgerKeyLiquidityPoolBuilder();
        }

        @Generated
        public LedgerKeyLiquidityPoolBuilder toBuilder() {
            return new LedgerKeyLiquidityPoolBuilder().liquidityPoolID(this.liquidityPoolID);
        }

        @Generated
        public PoolID getLiquidityPoolID() {
            return this.liquidityPoolID;
        }

        @Generated
        public void setLiquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyLiquidityPool)) {
                return false;
            }
            LedgerKeyLiquidityPool other = (LedgerKeyLiquidityPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PoolID this$liquidityPoolID = this.getLiquidityPoolID();
            PoolID other$liquidityPoolID = other.getLiquidityPoolID();
            return !(this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyLiquidityPool;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PoolID $liquidityPoolID = this.getLiquidityPoolID();
            result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyLiquidityPool(liquidityPoolID=" + this.getLiquidityPoolID() + ")";
        }

        @Generated
        public LedgerKeyLiquidityPool() {
        }

        @Generated
        public LedgerKeyLiquidityPool(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
        }

        @Generated
        public static class LedgerKeyLiquidityPoolBuilder {
            @Generated
            private PoolID liquidityPoolID;

            @Generated
            LedgerKeyLiquidityPoolBuilder() {
            }

            @Generated
            public LedgerKeyLiquidityPoolBuilder liquidityPoolID(PoolID liquidityPoolID) {
                this.liquidityPoolID = liquidityPoolID;
                return this;
            }

            @Generated
            public LedgerKeyLiquidityPool build() {
                return new LedgerKeyLiquidityPool(this.liquidityPoolID);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyLiquidityPool.LedgerKeyLiquidityPoolBuilder(liquidityPoolID=" + this.liquidityPoolID + ")";
            }
        }
    }

    public static class LedgerKeyClaimableBalance
    implements XdrElement {
        private ClaimableBalanceID balanceID;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.balanceID.encode(stream);
        }

        public static LedgerKeyClaimableBalance decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyClaimableBalance decodedLedgerKeyClaimableBalance = new LedgerKeyClaimableBalance();
            decodedLedgerKeyClaimableBalance.balanceID = ClaimableBalanceID.decode(stream);
            return decodedLedgerKeyClaimableBalance;
        }

        public static LedgerKeyClaimableBalance fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyClaimableBalance.fromXdrByteArray(bytes);
        }

        public static LedgerKeyClaimableBalance fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyClaimableBalance.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyClaimableBalanceBuilder builder() {
            return new LedgerKeyClaimableBalanceBuilder();
        }

        @Generated
        public LedgerKeyClaimableBalanceBuilder toBuilder() {
            return new LedgerKeyClaimableBalanceBuilder().balanceID(this.balanceID);
        }

        @Generated
        public ClaimableBalanceID getBalanceID() {
            return this.balanceID;
        }

        @Generated
        public void setBalanceID(ClaimableBalanceID balanceID) {
            this.balanceID = balanceID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyClaimableBalance)) {
                return false;
            }
            LedgerKeyClaimableBalance other = (LedgerKeyClaimableBalance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClaimableBalanceID this$balanceID = this.getBalanceID();
            ClaimableBalanceID other$balanceID = other.getBalanceID();
            return !(this$balanceID == null ? other$balanceID != null : !((Object)this$balanceID).equals(other$balanceID));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyClaimableBalance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClaimableBalanceID $balanceID = this.getBalanceID();
            result = result * 59 + ($balanceID == null ? 43 : ((Object)$balanceID).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyClaimableBalance(balanceID=" + this.getBalanceID() + ")";
        }

        @Generated
        public LedgerKeyClaimableBalance() {
        }

        @Generated
        public LedgerKeyClaimableBalance(ClaimableBalanceID balanceID) {
            this.balanceID = balanceID;
        }

        @Generated
        public static class LedgerKeyClaimableBalanceBuilder {
            @Generated
            private ClaimableBalanceID balanceID;

            @Generated
            LedgerKeyClaimableBalanceBuilder() {
            }

            @Generated
            public LedgerKeyClaimableBalanceBuilder balanceID(ClaimableBalanceID balanceID) {
                this.balanceID = balanceID;
                return this;
            }

            @Generated
            public LedgerKeyClaimableBalance build() {
                return new LedgerKeyClaimableBalance(this.balanceID);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyClaimableBalance.LedgerKeyClaimableBalanceBuilder(balanceID=" + this.balanceID + ")";
            }
        }
    }

    public static class LedgerKeyData
    implements XdrElement {
        private AccountID accountID;
        private String64 dataName;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.accountID.encode(stream);
            this.dataName.encode(stream);
        }

        public static LedgerKeyData decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyData decodedLedgerKeyData = new LedgerKeyData();
            decodedLedgerKeyData.accountID = AccountID.decode(stream);
            decodedLedgerKeyData.dataName = String64.decode(stream);
            return decodedLedgerKeyData;
        }

        public static LedgerKeyData fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyData.fromXdrByteArray(bytes);
        }

        public static LedgerKeyData fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyData.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyDataBuilder builder() {
            return new LedgerKeyDataBuilder();
        }

        @Generated
        public LedgerKeyDataBuilder toBuilder() {
            return new LedgerKeyDataBuilder().accountID(this.accountID).dataName(this.dataName);
        }

        @Generated
        public AccountID getAccountID() {
            return this.accountID;
        }

        @Generated
        public String64 getDataName() {
            return this.dataName;
        }

        @Generated
        public void setAccountID(AccountID accountID) {
            this.accountID = accountID;
        }

        @Generated
        public void setDataName(String64 dataName) {
            this.dataName = dataName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyData)) {
                return false;
            }
            LedgerKeyData other = (LedgerKeyData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$accountID = this.getAccountID();
            AccountID other$accountID = other.getAccountID();
            if (this$accountID == null ? other$accountID != null : !((Object)this$accountID).equals(other$accountID)) {
                return false;
            }
            String64 this$dataName = this.getDataName();
            String64 other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $accountID = this.getAccountID();
            result = result * 59 + ($accountID == null ? 43 : ((Object)$accountID).hashCode());
            String64 $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyData(accountID=" + this.getAccountID() + ", dataName=" + this.getDataName() + ")";
        }

        @Generated
        public LedgerKeyData() {
        }

        @Generated
        public LedgerKeyData(AccountID accountID, String64 dataName) {
            this.accountID = accountID;
            this.dataName = dataName;
        }

        @Generated
        public static class LedgerKeyDataBuilder {
            @Generated
            private AccountID accountID;
            @Generated
            private String64 dataName;

            @Generated
            LedgerKeyDataBuilder() {
            }

            @Generated
            public LedgerKeyDataBuilder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            @Generated
            public LedgerKeyDataBuilder dataName(String64 dataName) {
                this.dataName = dataName;
                return this;
            }

            @Generated
            public LedgerKeyData build() {
                return new LedgerKeyData(this.accountID, this.dataName);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyData.LedgerKeyDataBuilder(accountID=" + this.accountID + ", dataName=" + this.dataName + ")";
            }
        }
    }

    public static class LedgerKeyOffer
    implements XdrElement {
        private AccountID sellerID;
        private Int64 offerID;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.sellerID.encode(stream);
            this.offerID.encode(stream);
        }

        public static LedgerKeyOffer decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyOffer decodedLedgerKeyOffer = new LedgerKeyOffer();
            decodedLedgerKeyOffer.sellerID = AccountID.decode(stream);
            decodedLedgerKeyOffer.offerID = Int64.decode(stream);
            return decodedLedgerKeyOffer;
        }

        public static LedgerKeyOffer fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyOffer.fromXdrByteArray(bytes);
        }

        public static LedgerKeyOffer fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyOffer.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyOfferBuilder builder() {
            return new LedgerKeyOfferBuilder();
        }

        @Generated
        public LedgerKeyOfferBuilder toBuilder() {
            return new LedgerKeyOfferBuilder().sellerID(this.sellerID).offerID(this.offerID);
        }

        @Generated
        public AccountID getSellerID() {
            return this.sellerID;
        }

        @Generated
        public Int64 getOfferID() {
            return this.offerID;
        }

        @Generated
        public void setSellerID(AccountID sellerID) {
            this.sellerID = sellerID;
        }

        @Generated
        public void setOfferID(Int64 offerID) {
            this.offerID = offerID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyOffer)) {
                return false;
            }
            LedgerKeyOffer other = (LedgerKeyOffer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$sellerID = this.getSellerID();
            AccountID other$sellerID = other.getSellerID();
            if (this$sellerID == null ? other$sellerID != null : !((Object)this$sellerID).equals(other$sellerID)) {
                return false;
            }
            Int64 this$offerID = this.getOfferID();
            Int64 other$offerID = other.getOfferID();
            return !(this$offerID == null ? other$offerID != null : !((Object)this$offerID).equals(other$offerID));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyOffer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $sellerID = this.getSellerID();
            result = result * 59 + ($sellerID == null ? 43 : ((Object)$sellerID).hashCode());
            Int64 $offerID = this.getOfferID();
            result = result * 59 + ($offerID == null ? 43 : ((Object)$offerID).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyOffer(sellerID=" + this.getSellerID() + ", offerID=" + this.getOfferID() + ")";
        }

        @Generated
        public LedgerKeyOffer() {
        }

        @Generated
        public LedgerKeyOffer(AccountID sellerID, Int64 offerID) {
            this.sellerID = sellerID;
            this.offerID = offerID;
        }

        @Generated
        public static class LedgerKeyOfferBuilder {
            @Generated
            private AccountID sellerID;
            @Generated
            private Int64 offerID;

            @Generated
            LedgerKeyOfferBuilder() {
            }

            @Generated
            public LedgerKeyOfferBuilder sellerID(AccountID sellerID) {
                this.sellerID = sellerID;
                return this;
            }

            @Generated
            public LedgerKeyOfferBuilder offerID(Int64 offerID) {
                this.offerID = offerID;
                return this;
            }

            @Generated
            public LedgerKeyOffer build() {
                return new LedgerKeyOffer(this.sellerID, this.offerID);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyOffer.LedgerKeyOfferBuilder(sellerID=" + this.sellerID + ", offerID=" + this.offerID + ")";
            }
        }
    }

    public static class LedgerKeyTrustLine
    implements XdrElement {
        private AccountID accountID;
        private TrustLineAsset asset;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.accountID.encode(stream);
            this.asset.encode(stream);
        }

        public static LedgerKeyTrustLine decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyTrustLine decodedLedgerKeyTrustLine = new LedgerKeyTrustLine();
            decodedLedgerKeyTrustLine.accountID = AccountID.decode(stream);
            decodedLedgerKeyTrustLine.asset = TrustLineAsset.decode(stream);
            return decodedLedgerKeyTrustLine;
        }

        public static LedgerKeyTrustLine fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyTrustLine.fromXdrByteArray(bytes);
        }

        public static LedgerKeyTrustLine fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyTrustLine.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyTrustLineBuilder builder() {
            return new LedgerKeyTrustLineBuilder();
        }

        @Generated
        public LedgerKeyTrustLineBuilder toBuilder() {
            return new LedgerKeyTrustLineBuilder().accountID(this.accountID).asset(this.asset);
        }

        @Generated
        public AccountID getAccountID() {
            return this.accountID;
        }

        @Generated
        public TrustLineAsset getAsset() {
            return this.asset;
        }

        @Generated
        public void setAccountID(AccountID accountID) {
            this.accountID = accountID;
        }

        @Generated
        public void setAsset(TrustLineAsset asset) {
            this.asset = asset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyTrustLine)) {
                return false;
            }
            LedgerKeyTrustLine other = (LedgerKeyTrustLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$accountID = this.getAccountID();
            AccountID other$accountID = other.getAccountID();
            if (this$accountID == null ? other$accountID != null : !((Object)this$accountID).equals(other$accountID)) {
                return false;
            }
            TrustLineAsset this$asset = this.getAsset();
            TrustLineAsset other$asset = other.getAsset();
            return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyTrustLine;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $accountID = this.getAccountID();
            result = result * 59 + ($accountID == null ? 43 : ((Object)$accountID).hashCode());
            TrustLineAsset $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyTrustLine(accountID=" + this.getAccountID() + ", asset=" + this.getAsset() + ")";
        }

        @Generated
        public LedgerKeyTrustLine() {
        }

        @Generated
        public LedgerKeyTrustLine(AccountID accountID, TrustLineAsset asset) {
            this.accountID = accountID;
            this.asset = asset;
        }

        @Generated
        public static class LedgerKeyTrustLineBuilder {
            @Generated
            private AccountID accountID;
            @Generated
            private TrustLineAsset asset;

            @Generated
            LedgerKeyTrustLineBuilder() {
            }

            @Generated
            public LedgerKeyTrustLineBuilder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            @Generated
            public LedgerKeyTrustLineBuilder asset(TrustLineAsset asset) {
                this.asset = asset;
                return this;
            }

            @Generated
            public LedgerKeyTrustLine build() {
                return new LedgerKeyTrustLine(this.accountID, this.asset);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyTrustLine.LedgerKeyTrustLineBuilder(accountID=" + this.accountID + ", asset=" + this.asset + ")";
            }
        }
    }

    public static class LedgerKeyAccount
    implements XdrElement {
        private AccountID accountID;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.accountID.encode(stream);
        }

        public static LedgerKeyAccount decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyAccount decodedLedgerKeyAccount = new LedgerKeyAccount();
            decodedLedgerKeyAccount.accountID = AccountID.decode(stream);
            return decodedLedgerKeyAccount;
        }

        public static LedgerKeyAccount fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerKeyAccount.fromXdrByteArray(bytes);
        }

        public static LedgerKeyAccount fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerKeyAccount.decode(xdrDataInputStream);
        }

        @Generated
        public static LedgerKeyAccountBuilder builder() {
            return new LedgerKeyAccountBuilder();
        }

        @Generated
        public LedgerKeyAccountBuilder toBuilder() {
            return new LedgerKeyAccountBuilder().accountID(this.accountID);
        }

        @Generated
        public AccountID getAccountID() {
            return this.accountID;
        }

        @Generated
        public void setAccountID(AccountID accountID) {
            this.accountID = accountID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerKeyAccount)) {
                return false;
            }
            LedgerKeyAccount other = (LedgerKeyAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$accountID = this.getAccountID();
            AccountID other$accountID = other.getAccountID();
            return !(this$accountID == null ? other$accountID != null : !((Object)this$accountID).equals(other$accountID));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LedgerKeyAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $accountID = this.getAccountID();
            result = result * 59 + ($accountID == null ? 43 : ((Object)$accountID).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerKey.LedgerKeyAccount(accountID=" + this.getAccountID() + ")";
        }

        @Generated
        public LedgerKeyAccount() {
        }

        @Generated
        public LedgerKeyAccount(AccountID accountID) {
            this.accountID = accountID;
        }

        @Generated
        public static class LedgerKeyAccountBuilder {
            @Generated
            private AccountID accountID;

            @Generated
            LedgerKeyAccountBuilder() {
            }

            @Generated
            public LedgerKeyAccountBuilder accountID(AccountID accountID) {
                this.accountID = accountID;
                return this;
            }

            @Generated
            public LedgerKeyAccount build() {
                return new LedgerKeyAccount(this.accountID);
            }

            @Generated
            public String toString() {
                return "LedgerKey.LedgerKeyAccount.LedgerKeyAccountBuilder(accountID=" + this.accountID + ")";
            }
        }
    }
}

