/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum TrustLineFlags implements XdrElement
{
    AUTHORIZED_FLAG(1),
    AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG(2),
    TRUSTLINE_CLAWBACK_ENABLED_FLAG(4);

    private final int value;

    private TrustLineFlags(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TrustLineFlags decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return AUTHORIZED_FLAG;
            }
            case 2: {
                return AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG;
            }
            case 4: {
                return TRUSTLINE_CLAWBACK_ENABLED_FLAG;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static TrustLineFlags fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TrustLineFlags.fromXdrByteArray(bytes);
    }

    public static TrustLineFlags fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TrustLineFlags.decode(xdrDataInputStream);
    }
}

