/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.Account;
import org.stellar.sdk.MuxedAccount;
import org.stellar.sdk.Network;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilder;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.FeeBumpTransactionEnvelope;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;

public class FeeBumpTransaction
extends AbstractTransaction {
    @NonNull
    private final String feeSource;
    private final long fee;
    @NonNull
    private final Transaction innerTransaction;

    private FeeBumpTransaction(@NonNull String feeSource, long fee, @NonNull Transaction innerTransaction) {
        super(innerTransaction.getNetwork());
        if (feeSource == null) {
            throw new NullPointerException("feeSource is marked non-null but is null");
        }
        if (innerTransaction == null) {
            throw new NullPointerException("innerTransaction is marked non-null but is null");
        }
        this.feeSource = feeSource;
        this.fee = fee;
        this.innerTransaction = innerTransaction;
    }

    public static FeeBumpTransaction createWithFee(@NonNull String feeSource, long fee, @NonNull Transaction innerTransaction) {
        if (feeSource == null) {
            throw new NullPointerException("feeSource is marked non-null but is null");
        }
        if (innerTransaction == null) {
            throw new NullPointerException("innerTransaction is marked non-null but is null");
        }
        return new FeeBumpTransaction(feeSource, fee, innerTransaction);
    }

    public static FeeBumpTransaction createWithBaseFee(@NonNull String feeSource, long baseFee, @NonNull Transaction innerTransaction) {
        Transaction tx;
        if (feeSource == null) {
            throw new NullPointerException("feeSource is marked non-null but is null");
        }
        if (innerTransaction == null) {
            throw new NullPointerException("innerTransaction is marked non-null but is null");
        }
        if (baseFee < 100L) {
            throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
        }
        long innerSorobanResourceFee = 0L;
        if (innerTransaction.getSorobanData() != null) {
            innerSorobanResourceFee = innerTransaction.getSorobanData().getResourceFee().getInt64();
        }
        long innerBaseFee = innerTransaction.getFee() - innerSorobanResourceFee;
        long numOperations = innerTransaction.getOperations().length;
        if (numOperations > 0L) {
            innerBaseFee = (long)Math.ceil((double)innerBaseFee / (double)numOperations);
        }
        if (baseFee < innerBaseFee) {
            throw new IllegalArgumentException("base fee cannot be lower than provided inner transaction base fee");
        }
        long maxFee = baseFee * (numOperations + 1L) + innerSorobanResourceFee;
        if (maxFee < 0L) {
            throw new IllegalArgumentException("fee overflows 64 bit int");
        }
        EnvelopeType txType = innerTransaction.toEnvelopeXdr().getDiscriminant();
        if (txType == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
            tx = new TransactionBuilder(new Account(innerTransaction.getSourceAccount(), innerTransaction.getSequenceNumber() - 1L), innerTransaction.getNetwork()).setBaseFee((int)innerTransaction.getFee()).addOperations(Arrays.asList(innerTransaction.getOperations())).addMemo(innerTransaction.getMemo()).addPreconditions(new TransactionPreconditions.TransactionPreconditionsBuilder().timeBounds(innerTransaction.getTimeBounds()).build()).build();
            tx.signatures = new ArrayList(innerTransaction.signatures);
        } else {
            tx = innerTransaction;
        }
        return new FeeBumpTransaction(feeSource, maxFee, tx);
    }

    public static FeeBumpTransaction fromFeeBumpTransactionEnvelope(FeeBumpTransactionEnvelope envelope, Network network) {
        Transaction inner = Transaction.fromV1EnvelopeXdr(envelope.getTx().getInnerTx().getV1(), network);
        String feeSource = MuxedAccount.fromXdr(envelope.getTx().getFeeSource()).getAddress();
        long fee = envelope.getTx().getFee().getInt64();
        FeeBumpTransaction feeBump = new FeeBumpTransaction(feeSource, fee, inner);
        feeBump.signatures.addAll(Arrays.asList(envelope.getSignatures()));
        return feeBump;
    }

    private org.stellar.sdk.xdr.FeeBumpTransaction toXdr() {
        org.stellar.sdk.xdr.FeeBumpTransaction xdr = new org.stellar.sdk.xdr.FeeBumpTransaction();
        xdr.setExt(new FeeBumpTransaction.FeeBumpTransactionExt());
        xdr.getExt().setDiscriminant(0);
        Int64 xdrFee = new Int64();
        xdrFee.setInt64(this.fee);
        xdr.setFee(xdrFee);
        xdr.setFeeSource(new MuxedAccount(this.feeSource).toXdr());
        FeeBumpTransaction.FeeBumpTransactionInnerTx innerXDR = new FeeBumpTransaction.FeeBumpTransactionInnerTx();
        innerXDR.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
        innerXDR.setV1(this.innerTransaction.toEnvelopeXdr().getV1());
        xdr.setInnerTx(innerXDR);
        return xdr;
    }

    @Override
    public byte[] signatureBase() {
        TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
        taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_FEE_BUMP);
        taggedTransaction.setFeeBump(this.toXdr());
        return FeeBumpTransaction.getTransactionSignatureBase(taggedTransaction, this.network);
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        FeeBumpTransactionEnvelope feeBumpEnvelope = new FeeBumpTransactionEnvelope();
        xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_FEE_BUMP);
        feeBumpEnvelope.setTx(this.toXdr());
        DecoratedSignature[] signatures = new DecoratedSignature[this.signatures.size()];
        signatures = this.signatures.toArray(signatures);
        feeBumpEnvelope.setSignatures(signatures);
        xdr.setFeeBump(feeBumpEnvelope);
        return xdr;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FeeBumpTransaction that = (FeeBumpTransaction)object;
        return Arrays.equals(this.signatureBase(), that.signatureBase());
    }

    public int hashCode() {
        return Arrays.hashCode(this.signatureBase());
    }

    @NonNull
    @Generated
    public String getFeeSource() {
        return this.feeSource;
    }

    @Generated
    public long getFee() {
        return this.fee;
    }

    @NonNull
    @Generated
    public Transaction getInnerTransaction() {
        return this.innerTransaction;
    }
}

