/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Base32;
import org.stellar.sdk.Base32Factory;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class StrKey {
    private static final byte[] b32Table = StrKey.decodingTable();
    private static final Base32 base32Codec = Base32Factory.getInstance();

    public static String encodeEd25519PublicKey(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.ACCOUNT_ID, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeEd25519PublicKey(String data) {
        return StrKey.decodeCheck(VersionByte.ACCOUNT_ID, data.toCharArray());
    }

    public static boolean isValidEd25519PublicKey(String accountID) {
        try {
            StrKey.decodeEd25519PublicKey(accountID);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static char[] encodeEd25519SecretSeed(byte[] data) {
        return StrKey.encodeCheck(VersionByte.SEED, data);
    }

    public static byte[] decodeEd25519SecretSeed(char[] data) {
        return StrKey.decodeCheck(VersionByte.SEED, data);
    }

    public static boolean isValidEd25519SecretSeed(char[] seed) {
        try {
            StrKey.decodeEd25519SecretSeed(seed);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodePreAuthTx(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.PRE_AUTH_TX, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodePreAuthTx(String data) {
        return StrKey.decodeCheck(VersionByte.PRE_AUTH_TX, data.toCharArray());
    }

    public static boolean isValidPreAuthTx(String preAuthTx) {
        try {
            StrKey.decodePreAuthTx(preAuthTx);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodeSha256Hash(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.SHA256_HASH, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeSha256Hash(String data) {
        return StrKey.decodeCheck(VersionByte.SHA256_HASH, data.toCharArray());
    }

    public static boolean isValidSha256Hash(String sha256Hash) {
        try {
            StrKey.decodeSha256Hash(sha256Hash);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodeSignedPayload(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.SIGNED_PAYLOAD, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeSignedPayload(String data) {
        return StrKey.decodeCheck(VersionByte.SIGNED_PAYLOAD, data.toCharArray());
    }

    public static boolean isValidSignedPayload(String signedPayload) {
        try {
            StrKey.decodeSignedPayload(signedPayload);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodeContract(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.CONTRACT, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeContract(String data) {
        return StrKey.decodeCheck(VersionByte.CONTRACT, data.toCharArray());
    }

    public static boolean isValidContract(String contractId) {
        try {
            StrKey.decodeContract(contractId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodeLiquidityPool(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.LIQUIDITY_POOL, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeLiquidityPool(String data) {
        return StrKey.decodeCheck(VersionByte.LIQUIDITY_POOL, data.toCharArray());
    }

    public static boolean isValidLiquidityPool(String liquidityPoolId) {
        try {
            StrKey.decodeLiquidityPool(liquidityPoolId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodeClaimableBalance(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.CLAIMABLE_BALANCE, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeClaimableBalance(String data) {
        return StrKey.decodeCheck(VersionByte.CLAIMABLE_BALANCE, data.toCharArray());
    }

    public static boolean isValidClaimableBalance(String claimableBalanceId) {
        try {
            StrKey.decodeClaimableBalance(claimableBalanceId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String encodeMed25519PublicKey(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.MED25519_PUBLIC_KEY, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeMed25519PublicKey(String data) {
        return StrKey.decodeCheck(VersionByte.MED25519_PUBLIC_KEY, data.toCharArray());
    }

    public static boolean isValidMed25519PublicKey(String med25519PublicKey) {
        try {
            StrKey.decodeMed25519PublicKey(med25519PublicKey);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public static String encodeEd25519PublicKey(AccountID accountID) {
        char[] encoded = StrKey.encodeCheck(VersionByte.ACCOUNT_ID, accountID.getAccountID().getEd25519().getUint256());
        return String.valueOf(encoded);
    }

    @Deprecated
    public static String encodeMuxedAccount(MuxedAccount muxedAccount) {
        switch (muxedAccount.getDiscriminant()) {
            case KEY_TYPE_MUXED_ED25519: {
                return String.valueOf(StrKey.encodeCheck(VersionByte.MED25519_PUBLIC_KEY, StrKey.getMuxedEd25519AccountBytes(muxedAccount)));
            }
            case KEY_TYPE_ED25519: {
                return String.valueOf(StrKey.encodeCheck(VersionByte.ACCOUNT_ID, muxedAccount.getEd25519().getUint256()));
            }
        }
        throw new IllegalArgumentException("invalid discriminant");
    }

    @Deprecated
    public static MuxedAccount decodeMuxedAccount(String address) {
        return StrKey.encodeToXDRMuxedAccount(address);
    }

    @Deprecated
    public static AccountID encodeToXDRAccountId(String data) {
        AccountID accountID = new AccountID();
        PublicKey publicKey = new PublicKey();
        publicKey.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        try {
            publicKey.setEd25519(Uint256.fromXdrByteArray(StrKey.decodeEd25519PublicKey(data)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid address: " + data, e);
        }
        accountID.setAccountID(publicKey);
        return accountID;
    }

    @Deprecated
    public static MuxedAccount encodeToXDRMuxedAccount(String data) {
        MuxedAccount muxed = new MuxedAccount();
        if (data.isEmpty()) {
            throw new IllegalArgumentException("address is empty");
        }
        switch (StrKey.decodeVersionByte(data)) {
            case ACCOUNT_ID: {
                muxed.setDiscriminant(CryptoKeyType.KEY_TYPE_ED25519);
                byte[] rawEd25519PublicKey = StrKey.decodeEd25519PublicKey(data);
                try {
                    muxed.setEd25519(Uint256.fromXdrByteArray(rawEd25519PublicKey));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("invalid address: " + data, e);
                }
            }
            case MED25519_PUBLIC_KEY: {
                XdrDataInputStream input = new XdrDataInputStream(new ByteArrayInputStream(StrKey.decodeCheck(VersionByte.MED25519_PUBLIC_KEY, data.toCharArray())));
                muxed.setDiscriminant(CryptoKeyType.KEY_TYPE_MUXED_ED25519);
                MuxedAccount.MuxedAccountMed25519 med = new MuxedAccount.MuxedAccountMed25519();
                try {
                    med.setEd25519(Uint256.decode(input));
                    med.setId(new Uint64(XdrUnsignedHyperInteger.decode(input)));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("invalid address: " + data, e);
                }
                muxed.setMed25519(med);
                break;
            }
            default: {
                throw new IllegalArgumentException("Version byte is invalid");
            }
        }
        return muxed;
    }

    static VersionByte decodeVersionByte(String data) {
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] decoded = StrKey.base32decode(dataBytes);
        byte decodedVersionByte = decoded[0];
        Optional<VersionByte> versionByteOptional = VersionByte.findByValue(decodedVersionByte);
        if (!versionByteOptional.isPresent()) {
            throw new IllegalArgumentException("Version byte is invalid");
        }
        return versionByteOptional.get();
    }

    static char[] encodeCheck(VersionByte versionByte, byte[] data) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(versionByte.getValue());
        try {
            outputStream.write(data);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        byte[] payload = outputStream.toByteArray();
        byte[] checksum = StrKey.calculateChecksum(payload);
        try {
            outputStream.write(checksum);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        byte[] unencoded = outputStream.toByteArray();
        byte[] encodedBytes = base32Codec.encode(unencoded);
        byte[] unpaddedEncodedBytes = StrKey.removeBase32Padding(encodedBytes);
        char[] charsEncoded = StrKey.bytesToChars(unpaddedEncodedBytes);
        if (VersionByte.SEED != versionByte) {
            return charsEncoded;
        }
        Arrays.fill(unencoded, (byte)0);
        Arrays.fill(payload, (byte)0);
        Arrays.fill(checksum, (byte)0);
        Arrays.fill(encodedBytes, (byte)0);
        Arrays.fill(unpaddedEncodedBytes, (byte)0);
        return charsEncoded;
    }

    static byte[] decodeCheck(VersionByte versionByte, char[] encoded) {
        byte leftoverBitsMask;
        byte lastChar;
        byte decodedLastChar;
        byte[] bytes = new byte[encoded.length];
        for (int i = 0; i < encoded.length; ++i) {
            bytes[i] = (byte)encoded[i];
        }
        if (bytes.length < 5) {
            throw new IllegalArgumentException("Encoded char array must have a length of at least 5.");
        }
        int leftoverBits = bytes.length * 5 % 8;
        if (leftoverBits >= 5) {
            throw new IllegalArgumentException("Encoded char array has leftover character.");
        }
        if (leftoverBits > 0 && ((decodedLastChar = b32Table[lastChar = bytes[bytes.length - 1]]) & (leftoverBitsMask = (byte)(15 >> 4 - leftoverBits))) != 0) {
            throw new IllegalArgumentException("Unused bits should be set to 0.");
        }
        byte[] decoded = StrKey.base32decode(bytes);
        byte decodedVersionByte = decoded[0];
        VersionByte decodedVersionByteEnum = VersionByte.findByValue(decodedVersionByte).orElseThrow(() -> new IllegalArgumentException("Version byte is invalid"));
        byte[] payload = Arrays.copyOfRange(decoded, 0, decoded.length - 2);
        byte[] data = Arrays.copyOfRange(payload, 1, payload.length);
        byte[] checksum = Arrays.copyOfRange(decoded, decoded.length - 2, decoded.length);
        switch (decodedVersionByteEnum) {
            case SIGNED_PAYLOAD: {
                if (data.length >= 40 && data.length <= 100) break;
                throw new IllegalArgumentException("Invalid data length, the length should be between 40 and 100 bytes, got " + data.length);
            }
            case MED25519_PUBLIC_KEY: {
                if (data.length == 40) break;
                throw new IllegalArgumentException("Invalid data length, expected 40 bytes, got " + data.length);
            }
            case CLAIMABLE_BALANCE: {
                if (data.length == 33) break;
                throw new IllegalArgumentException("Invalid data length, expected 33 bytes, got " + data.length);
            }
            default: {
                if (data.length == 32) break;
                throw new IllegalArgumentException("Invalid data length, expected 32 bytes, got " + data.length);
            }
        }
        if (decodedVersionByteEnum != versionByte) {
            throw new IllegalArgumentException("Version byte mismatch");
        }
        byte[] expectedChecksum = StrKey.calculateChecksum(payload);
        if (!Arrays.equals(expectedChecksum, checksum)) {
            throw new IllegalArgumentException("Checksum invalid");
        }
        if (VersionByte.SIGNED_PAYLOAD.getValue() == decodedVersionByte) {
            byte[] lengthBytes = Arrays.copyOfRange(data, 32, 36);
            int payloadLength = ByteBuffer.wrap(lengthBytes).getInt();
            int padding = (4 - payloadLength % 4) % 4;
            if (data.length % 4 != 0 || payloadLength + padding != data.length - 36) {
                throw new IllegalArgumentException("Invalid Ed25519 Signed Payload Key");
            }
        }
        if (VersionByte.SEED.getValue() == decodedVersionByte) {
            Arrays.fill(bytes, (byte)0);
            Arrays.fill(decoded, (byte)0);
            Arrays.fill(payload, (byte)0);
        }
        return data;
    }

    private static byte[] calculateChecksum(byte[] bytes) {
        int crc = 0;
        int i = 0;
        for (int count = bytes.length; count > 0; --count) {
            int code = crc >>> 8 & 0xFF;
            code ^= bytes[i++] & 0xFF;
            code ^= code >>> 4;
            crc = crc << 8 & 0xFFFF;
            crc ^= code;
            code = code << 5 & 0xFFFF;
            crc ^= code;
            code = code << 7 & 0xFFFF;
            crc ^= code;
        }
        return new byte[]{(byte)crc, (byte)(crc >>> 8)};
    }

    private static byte[] decodingTable() {
        byte[] table = new byte[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = -1;
        }
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
        for (int i = 0; i < alphabet.length(); ++i) {
            table[alphabet.charAt((int)i)] = (byte)i;
        }
        return table;
    }

    @Deprecated
    private static byte[] getMuxedEd25519AccountBytes(MuxedAccount muxedAccount) {
        byte[] accountBytes = muxedAccount.getMed25519().getEd25519().getUint256();
        byte[] idBytes = muxedAccount.getMed25519().getId().getUint64().getNumber().toByteArray();
        byte[] idPaddedBytes = new byte[8];
        int idNumBytesToCopy = Math.min(idBytes.length, 8);
        int idCopyStartIndex = idBytes.length - idNumBytesToCopy;
        System.arraycopy(idBytes, idCopyStartIndex, idPaddedBytes, 8 - idNumBytesToCopy, idNumBytesToCopy);
        byte[] result = new byte[accountBytes.length + idPaddedBytes.length];
        System.arraycopy(accountBytes, 0, result, 0, accountBytes.length);
        System.arraycopy(idPaddedBytes, 0, result, accountBytes.length, idPaddedBytes.length);
        return result;
    }

    private static byte[] removeBase32Padding(byte[] data) {
        int unpaddedLength;
        for (unpaddedLength = data.length; unpaddedLength > 0 && data[unpaddedLength - 1] == 61; --unpaddedLength) {
        }
        return Arrays.copyOf(data, unpaddedLength);
    }

    private static char[] bytesToChars(byte[] data) {
        char[] chars = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            chars[i] = (char)(data[i] & 0xFF);
        }
        return chars;
    }

    private static byte[] base32decode(byte[] data) {
        if (!StrKey.isInAlphabet(data)) {
            throw new IllegalArgumentException("Invalid base32 encoded string");
        }
        return base32Codec.decode(data);
    }

    private static boolean isInAlphabet(byte[] arrayOctet) {
        for (byte octet : arrayOctet) {
            if (octet >= 0 && octet < b32Table.length && b32Table[octet] != -1) continue;
            return false;
        }
        return true;
    }

    static byte[] toRawMuxedAccountStrKey(RawMuxedAccountStrKeyParameter parameter) {
        long idLong = parameter.getId().getUint64().getNumber().longValue();
        byte[] ed25519Bytes = parameter.getEd25519().getUint256();
        return ByteBuffer.allocate(ed25519Bytes.length + 8).put(ed25519Bytes).putLong(idLong).array();
    }

    static RawMuxedAccountStrKeyParameter fromRawMuxedAccountStrKey(byte @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (data.length != 40) {
            throw new IllegalArgumentException("Muxed account bytes must be 40 bytes long, got " + data.length);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte[] ed25519Bytes = new byte[32];
        buffer.get(ed25519Bytes);
        byte[] idBytes = new byte[8];
        buffer.get(idBytes);
        Uint256 ed25519 = new Uint256(ed25519Bytes);
        Uint64 id = new Uint64(new XdrUnsignedHyperInteger(new BigInteger(1, idBytes)));
        return new RawMuxedAccountStrKeyParameter(ed25519, id);
    }

    static enum VersionByte {
        ACCOUNT_ID(48),
        MED25519_PUBLIC_KEY(96),
        SEED(-112),
        PRE_AUTH_TX(-104),
        SHA256_HASH(-72),
        SIGNED_PAYLOAD(120),
        CONTRACT(16),
        LIQUIDITY_POOL(88),
        CLAIMABLE_BALANCE(8);

        private final byte value;

        private VersionByte(byte value) {
            this.value = value;
        }

        public static Optional<VersionByte> findByValue(byte value) {
            for (VersionByte versionByte : VersionByte.values()) {
                if (value != versionByte.value) continue;
                return Optional.of(versionByte);
            }
            return Optional.empty();
        }

        public int getValue() {
            return this.value;
        }
    }

    static final class RawMuxedAccountStrKeyParameter {
        @NonNull
        private final Uint256 ed25519;
        @NonNull
        private final Uint64 id;

        @Generated
        public RawMuxedAccountStrKeyParameter(@NonNull Uint256 ed25519, @NonNull Uint64 id) {
            if (ed25519 == null) {
                throw new NullPointerException("ed25519 is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.ed25519 = ed25519;
            this.id = id;
        }

        @NonNull
        @Generated
        public Uint256 getEd25519() {
            return this.ed25519;
        }

        @NonNull
        @Generated
        public Uint64 getId() {
            return this.id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RawMuxedAccountStrKeyParameter)) {
                return false;
            }
            RawMuxedAccountStrKeyParameter other = (RawMuxedAccountStrKeyParameter)o;
            Uint256 this$ed25519 = this.getEd25519();
            Uint256 other$ed25519 = other.getEd25519();
            if (this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519)) {
                return false;
            }
            Uint64 this$id = this.getId();
            Uint64 other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Uint256 $ed25519 = this.getEd25519();
            result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
            Uint64 $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StrKey.RawMuxedAccountStrKeyParameter(ed25519=" + this.getEd25519() + ", id=" + this.getId() + ")";
        }
    }
}

