/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.sorobanrpc;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.stellar.sdk.Util;
import org.stellar.sdk.requests.sorobanrpc.EventFilterType;
import org.stellar.sdk.xdr.SCVal;

public final class GetEventsResponse {
    private final List<EventInfo> events;
    private final String cursor;
    private final Long latestLedger;
    private final Long oldestLedger;
    private final Long latestLedgerCloseTime;
    private final Long oldestLedgerCloseTime;

    @Generated
    public GetEventsResponse(List<EventInfo> events, String cursor, Long latestLedger, Long oldestLedger, Long latestLedgerCloseTime, Long oldestLedgerCloseTime) {
        this.events = events;
        this.cursor = cursor;
        this.latestLedger = latestLedger;
        this.oldestLedger = oldestLedger;
        this.latestLedgerCloseTime = latestLedgerCloseTime;
        this.oldestLedgerCloseTime = oldestLedgerCloseTime;
    }

    @Generated
    public List<EventInfo> getEvents() {
        return this.events;
    }

    @Generated
    public String getCursor() {
        return this.cursor;
    }

    @Generated
    public Long getLatestLedger() {
        return this.latestLedger;
    }

    @Generated
    public Long getOldestLedger() {
        return this.oldestLedger;
    }

    @Generated
    public Long getLatestLedgerCloseTime() {
        return this.latestLedgerCloseTime;
    }

    @Generated
    public Long getOldestLedgerCloseTime() {
        return this.oldestLedgerCloseTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEventsResponse)) {
            return false;
        }
        GetEventsResponse other = (GetEventsResponse)o;
        Long this$latestLedger = this.getLatestLedger();
        Long other$latestLedger = other.getLatestLedger();
        if (this$latestLedger == null ? other$latestLedger != null : !((Object)this$latestLedger).equals(other$latestLedger)) {
            return false;
        }
        Long this$oldestLedger = this.getOldestLedger();
        Long other$oldestLedger = other.getOldestLedger();
        if (this$oldestLedger == null ? other$oldestLedger != null : !((Object)this$oldestLedger).equals(other$oldestLedger)) {
            return false;
        }
        Long this$latestLedgerCloseTime = this.getLatestLedgerCloseTime();
        Long other$latestLedgerCloseTime = other.getLatestLedgerCloseTime();
        if (this$latestLedgerCloseTime == null ? other$latestLedgerCloseTime != null : !((Object)this$latestLedgerCloseTime).equals(other$latestLedgerCloseTime)) {
            return false;
        }
        Long this$oldestLedgerCloseTime = this.getOldestLedgerCloseTime();
        Long other$oldestLedgerCloseTime = other.getOldestLedgerCloseTime();
        if (this$oldestLedgerCloseTime == null ? other$oldestLedgerCloseTime != null : !((Object)this$oldestLedgerCloseTime).equals(other$oldestLedgerCloseTime)) {
            return false;
        }
        List<EventInfo> this$events = this.getEvents();
        List<EventInfo> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $latestLedger = this.getLatestLedger();
        result = result * 59 + ($latestLedger == null ? 43 : ((Object)$latestLedger).hashCode());
        Long $oldestLedger = this.getOldestLedger();
        result = result * 59 + ($oldestLedger == null ? 43 : ((Object)$oldestLedger).hashCode());
        Long $latestLedgerCloseTime = this.getLatestLedgerCloseTime();
        result = result * 59 + ($latestLedgerCloseTime == null ? 43 : ((Object)$latestLedgerCloseTime).hashCode());
        Long $oldestLedgerCloseTime = this.getOldestLedgerCloseTime();
        result = result * 59 + ($oldestLedgerCloseTime == null ? 43 : ((Object)$oldestLedgerCloseTime).hashCode());
        List<EventInfo> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetEventsResponse(events=" + this.getEvents() + ", cursor=" + this.getCursor() + ", latestLedger=" + this.getLatestLedger() + ", oldestLedger=" + this.getOldestLedger() + ", latestLedgerCloseTime=" + this.getLatestLedgerCloseTime() + ", oldestLedgerCloseTime=" + this.getOldestLedgerCloseTime() + ")";
    }

    public static final class EventInfo {
        private final EventFilterType type;
        private final Long ledger;
        private final String ledgerClosedAt;
        private final String contractId;
        private final String id;
        private final Long operationIndex;
        private final Long transactionIndex;
        @SerializedName(value="txHash")
        private final String transactionHash;
        private final List<String> topic;
        private final String value;
        private final Boolean inSuccessfulContractCall;

        public List<SCVal> parseTopic() {
            if (this.topic == null) {
                return null;
            }
            return this.topic.stream().map(t -> Util.parseXdr(t, SCVal::fromXdrBase64)).collect(Collectors.toList());
        }

        public SCVal parseValue() {
            return Util.parseXdr(this.value, SCVal::fromXdrBase64);
        }

        @Generated
        public EventInfo(EventFilterType type, Long ledger, String ledgerClosedAt, String contractId, String id, Long operationIndex, Long transactionIndex, String transactionHash, List<String> topic, String value, Boolean inSuccessfulContractCall) {
            this.type = type;
            this.ledger = ledger;
            this.ledgerClosedAt = ledgerClosedAt;
            this.contractId = contractId;
            this.id = id;
            this.operationIndex = operationIndex;
            this.transactionIndex = transactionIndex;
            this.transactionHash = transactionHash;
            this.topic = topic;
            this.value = value;
            this.inSuccessfulContractCall = inSuccessfulContractCall;
        }

        @Generated
        public EventFilterType getType() {
            return this.type;
        }

        @Generated
        public Long getLedger() {
            return this.ledger;
        }

        @Generated
        public String getLedgerClosedAt() {
            return this.ledgerClosedAt;
        }

        @Generated
        public String getContractId() {
            return this.contractId;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Long getOperationIndex() {
            return this.operationIndex;
        }

        @Generated
        public Long getTransactionIndex() {
            return this.transactionIndex;
        }

        @Generated
        public String getTransactionHash() {
            return this.transactionHash;
        }

        @Generated
        public List<String> getTopic() {
            return this.topic;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Boolean getInSuccessfulContractCall() {
            return this.inSuccessfulContractCall;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventInfo)) {
                return false;
            }
            EventInfo other = (EventInfo)o;
            Long this$ledger = this.getLedger();
            Long other$ledger = other.getLedger();
            if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
                return false;
            }
            Long this$operationIndex = this.getOperationIndex();
            Long other$operationIndex = other.getOperationIndex();
            if (this$operationIndex == null ? other$operationIndex != null : !((Object)this$operationIndex).equals(other$operationIndex)) {
                return false;
            }
            Long this$transactionIndex = this.getTransactionIndex();
            Long other$transactionIndex = other.getTransactionIndex();
            if (this$transactionIndex == null ? other$transactionIndex != null : !((Object)this$transactionIndex).equals(other$transactionIndex)) {
                return false;
            }
            Boolean this$inSuccessfulContractCall = this.getInSuccessfulContractCall();
            Boolean other$inSuccessfulContractCall = other.getInSuccessfulContractCall();
            if (this$inSuccessfulContractCall == null ? other$inSuccessfulContractCall != null : !((Object)this$inSuccessfulContractCall).equals(other$inSuccessfulContractCall)) {
                return false;
            }
            EventFilterType this$type = this.getType();
            EventFilterType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$ledgerClosedAt = this.getLedgerClosedAt();
            String other$ledgerClosedAt = other.getLedgerClosedAt();
            if (this$ledgerClosedAt == null ? other$ledgerClosedAt != null : !this$ledgerClosedAt.equals(other$ledgerClosedAt)) {
                return false;
            }
            String this$contractId = this.getContractId();
            String other$contractId = other.getContractId();
            if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$transactionHash = this.getTransactionHash();
            String other$transactionHash = other.getTransactionHash();
            if (this$transactionHash == null ? other$transactionHash != null : !this$transactionHash.equals(other$transactionHash)) {
                return false;
            }
            List<String> this$topic = this.getTopic();
            List<String> other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !((Object)this$topic).equals(other$topic)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $ledger = this.getLedger();
            result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
            Long $operationIndex = this.getOperationIndex();
            result = result * 59 + ($operationIndex == null ? 43 : ((Object)$operationIndex).hashCode());
            Long $transactionIndex = this.getTransactionIndex();
            result = result * 59 + ($transactionIndex == null ? 43 : ((Object)$transactionIndex).hashCode());
            Boolean $inSuccessfulContractCall = this.getInSuccessfulContractCall();
            result = result * 59 + ($inSuccessfulContractCall == null ? 43 : ((Object)$inSuccessfulContractCall).hashCode());
            EventFilterType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $ledgerClosedAt = this.getLedgerClosedAt();
            result = result * 59 + ($ledgerClosedAt == null ? 43 : $ledgerClosedAt.hashCode());
            String $contractId = this.getContractId();
            result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $transactionHash = this.getTransactionHash();
            result = result * 59 + ($transactionHash == null ? 43 : $transactionHash.hashCode());
            List<String> $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : ((Object)$topic).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GetEventsResponse.EventInfo(type=" + (Object)((Object)this.getType()) + ", ledger=" + this.getLedger() + ", ledgerClosedAt=" + this.getLedgerClosedAt() + ", contractId=" + this.getContractId() + ", id=" + this.getId() + ", operationIndex=" + this.getOperationIndex() + ", transactionIndex=" + this.getTransactionIndex() + ", transactionHash=" + this.getTransactionHash() + ", topic=" + this.getTopic() + ", value=" + this.getValue() + ", inSuccessfulContractCall=" + this.getInSuccessfulContractCall() + ")";
        }
    }
}

