/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ContractIDPreimageType implements XdrElement
{
    CONTRACT_ID_PREIMAGE_FROM_ADDRESS(0),
    CONTRACT_ID_PREIMAGE_FROM_ASSET(1);

    private final int value;

    private ContractIDPreimageType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractIDPreimageType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CONTRACT_ID_PREIMAGE_FROM_ADDRESS;
            }
            case 1: {
                return CONTRACT_ID_PREIMAGE_FROM_ASSET;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ContractIDPreimageType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractIDPreimageType.fromXdrByteArray(bytes);
    }

    public static ContractIDPreimageType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractIDPreimageType.decode(xdrDataInputStream);
    }
}

