/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCSpecEventDataFormat implements XdrElement
{
    SC_SPEC_EVENT_DATA_FORMAT_SINGLE_VALUE(0),
    SC_SPEC_EVENT_DATA_FORMAT_VEC(1),
    SC_SPEC_EVENT_DATA_FORMAT_MAP(2);

    private final int value;

    private SCSpecEventDataFormat(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SCSpecEventDataFormat decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SC_SPEC_EVENT_DATA_FORMAT_SINGLE_VALUE;
            }
            case 1: {
                return SC_SPEC_EVENT_DATA_FORMAT_VEC;
            }
            case 2: {
                return SC_SPEC_EVENT_DATA_FORMAT_MAP;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SCSpecEventDataFormat fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecEventDataFormat.fromXdrByteArray(bytes);
    }

    public static SCSpecEventDataFormat fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecEventDataFormat.decode(xdrDataInputStream);
    }
}

