/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecUDTStructFieldV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecUDTStructV0
implements XdrElement {
    private XdrString doc;
    private XdrString lib;
    private XdrString name;
    private SCSpecUDTStructFieldV0[] fields;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.doc.encode(stream);
        this.lib.encode(stream);
        this.name.encode(stream);
        int fieldsSize = this.getFields().length;
        stream.writeInt(fieldsSize);
        for (int i = 0; i < fieldsSize; ++i) {
            this.fields[i].encode(stream);
        }
    }

    public static SCSpecUDTStructV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecUDTStructV0 decodedSCSpecUDTStructV0 = new SCSpecUDTStructV0();
        decodedSCSpecUDTStructV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecUDTStructV0.lib = XdrString.decode(stream, 80);
        decodedSCSpecUDTStructV0.name = XdrString.decode(stream, 60);
        int fieldsSize = stream.readInt();
        decodedSCSpecUDTStructV0.fields = new SCSpecUDTStructFieldV0[fieldsSize];
        for (int i = 0; i < fieldsSize; ++i) {
            decodedSCSpecUDTStructV0.fields[i] = SCSpecUDTStructFieldV0.decode(stream);
        }
        return decodedSCSpecUDTStructV0;
    }

    public static SCSpecUDTStructV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecUDTStructV0.fromXdrByteArray(bytes);
    }

    public static SCSpecUDTStructV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecUDTStructV0.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecUDTStructV0Builder builder() {
        return new SCSpecUDTStructV0Builder();
    }

    @Generated
    public SCSpecUDTStructV0Builder toBuilder() {
        return new SCSpecUDTStructV0Builder().doc(this.doc).lib(this.lib).name(this.name).fields(this.fields);
    }

    @Generated
    public XdrString getDoc() {
        return this.doc;
    }

    @Generated
    public XdrString getLib() {
        return this.lib;
    }

    @Generated
    public XdrString getName() {
        return this.name;
    }

    @Generated
    public SCSpecUDTStructFieldV0[] getFields() {
        return this.fields;
    }

    @Generated
    public void setDoc(XdrString doc) {
        this.doc = doc;
    }

    @Generated
    public void setLib(XdrString lib) {
        this.lib = lib;
    }

    @Generated
    public void setName(XdrString name) {
        this.name = name;
    }

    @Generated
    public void setFields(SCSpecUDTStructFieldV0[] fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecUDTStructV0)) {
            return false;
        }
        SCSpecUDTStructV0 other = (SCSpecUDTStructV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XdrString this$doc = this.getDoc();
        XdrString other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        XdrString this$lib = this.getLib();
        XdrString other$lib = other.getLib();
        if (this$lib == null ? other$lib != null : !((Object)this$lib).equals(other$lib)) {
            return false;
        }
        XdrString this$name = this.getName();
        XdrString other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        return Arrays.deepEquals(this.getFields(), other.getFields());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecUDTStructV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XdrString $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        XdrString $lib = this.getLib();
        result = result * 59 + ($lib == null ? 43 : ((Object)$lib).hashCode());
        XdrString $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecUDTStructV0(doc=" + this.getDoc() + ", lib=" + this.getLib() + ", name=" + this.getName() + ", fields=" + Arrays.deepToString(this.getFields()) + ")";
    }

    @Generated
    public SCSpecUDTStructV0() {
    }

    @Generated
    public SCSpecUDTStructV0(XdrString doc, XdrString lib, XdrString name, SCSpecUDTStructFieldV0[] fields) {
        this.doc = doc;
        this.lib = lib;
        this.name = name;
        this.fields = fields;
    }

    @Generated
    public static class SCSpecUDTStructV0Builder {
        @Generated
        private XdrString doc;
        @Generated
        private XdrString lib;
        @Generated
        private XdrString name;
        @Generated
        private SCSpecUDTStructFieldV0[] fields;

        @Generated
        SCSpecUDTStructV0Builder() {
        }

        @Generated
        public SCSpecUDTStructV0Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        @Generated
        public SCSpecUDTStructV0Builder lib(XdrString lib) {
            this.lib = lib;
            return this;
        }

        @Generated
        public SCSpecUDTStructV0Builder name(XdrString name) {
            this.name = name;
            return this;
        }

        @Generated
        public SCSpecUDTStructV0Builder fields(SCSpecUDTStructFieldV0[] fields) {
            this.fields = fields;
            return this;
        }

        @Generated
        public SCSpecUDTStructV0 build() {
            return new SCSpecUDTStructV0(this.doc, this.lib, this.name, this.fields);
        }

        @Generated
        public String toString() {
            return "SCSpecUDTStructV0.SCSpecUDTStructV0Builder(doc=" + this.doc + ", lib=" + this.lib + ", name=" + this.name + ", fields=" + Arrays.deepToString(this.fields) + ")";
        }
    }
}

