/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class StateArchivalSettings
implements XdrElement {
    private Uint32 maxEntryTTL;
    private Uint32 minTemporaryTTL;
    private Uint32 minPersistentTTL;
    private Int64 persistentRentRateDenominator;
    private Int64 tempRentRateDenominator;
    private Uint32 maxEntriesToArchive;
    private Uint32 liveSorobanStateSizeWindowSampleSize;
    private Uint32 liveSorobanStateSizeWindowSamplePeriod;
    private Uint32 evictionScanSize;
    private Uint32 startingEvictionScanLevel;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.maxEntryTTL.encode(stream);
        this.minTemporaryTTL.encode(stream);
        this.minPersistentTTL.encode(stream);
        this.persistentRentRateDenominator.encode(stream);
        this.tempRentRateDenominator.encode(stream);
        this.maxEntriesToArchive.encode(stream);
        this.liveSorobanStateSizeWindowSampleSize.encode(stream);
        this.liveSorobanStateSizeWindowSamplePeriod.encode(stream);
        this.evictionScanSize.encode(stream);
        this.startingEvictionScanLevel.encode(stream);
    }

    public static StateArchivalSettings decode(XdrDataInputStream stream) throws IOException {
        StateArchivalSettings decodedStateArchivalSettings = new StateArchivalSettings();
        decodedStateArchivalSettings.maxEntryTTL = Uint32.decode(stream);
        decodedStateArchivalSettings.minTemporaryTTL = Uint32.decode(stream);
        decodedStateArchivalSettings.minPersistentTTL = Uint32.decode(stream);
        decodedStateArchivalSettings.persistentRentRateDenominator = Int64.decode(stream);
        decodedStateArchivalSettings.tempRentRateDenominator = Int64.decode(stream);
        decodedStateArchivalSettings.maxEntriesToArchive = Uint32.decode(stream);
        decodedStateArchivalSettings.liveSorobanStateSizeWindowSampleSize = Uint32.decode(stream);
        decodedStateArchivalSettings.liveSorobanStateSizeWindowSamplePeriod = Uint32.decode(stream);
        decodedStateArchivalSettings.evictionScanSize = Uint32.decode(stream);
        decodedStateArchivalSettings.startingEvictionScanLevel = Uint32.decode(stream);
        return decodedStateArchivalSettings;
    }

    public static StateArchivalSettings fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return StateArchivalSettings.fromXdrByteArray(bytes);
    }

    public static StateArchivalSettings fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return StateArchivalSettings.decode(xdrDataInputStream);
    }

    @Generated
    public static StateArchivalSettingsBuilder builder() {
        return new StateArchivalSettingsBuilder();
    }

    @Generated
    public StateArchivalSettingsBuilder toBuilder() {
        return new StateArchivalSettingsBuilder().maxEntryTTL(this.maxEntryTTL).minTemporaryTTL(this.minTemporaryTTL).minPersistentTTL(this.minPersistentTTL).persistentRentRateDenominator(this.persistentRentRateDenominator).tempRentRateDenominator(this.tempRentRateDenominator).maxEntriesToArchive(this.maxEntriesToArchive).liveSorobanStateSizeWindowSampleSize(this.liveSorobanStateSizeWindowSampleSize).liveSorobanStateSizeWindowSamplePeriod(this.liveSorobanStateSizeWindowSamplePeriod).evictionScanSize(this.evictionScanSize).startingEvictionScanLevel(this.startingEvictionScanLevel);
    }

    @Generated
    public Uint32 getMaxEntryTTL() {
        return this.maxEntryTTL;
    }

    @Generated
    public Uint32 getMinTemporaryTTL() {
        return this.minTemporaryTTL;
    }

    @Generated
    public Uint32 getMinPersistentTTL() {
        return this.minPersistentTTL;
    }

    @Generated
    public Int64 getPersistentRentRateDenominator() {
        return this.persistentRentRateDenominator;
    }

    @Generated
    public Int64 getTempRentRateDenominator() {
        return this.tempRentRateDenominator;
    }

    @Generated
    public Uint32 getMaxEntriesToArchive() {
        return this.maxEntriesToArchive;
    }

    @Generated
    public Uint32 getLiveSorobanStateSizeWindowSampleSize() {
        return this.liveSorobanStateSizeWindowSampleSize;
    }

    @Generated
    public Uint32 getLiveSorobanStateSizeWindowSamplePeriod() {
        return this.liveSorobanStateSizeWindowSamplePeriod;
    }

    @Generated
    public Uint32 getEvictionScanSize() {
        return this.evictionScanSize;
    }

    @Generated
    public Uint32 getStartingEvictionScanLevel() {
        return this.startingEvictionScanLevel;
    }

    @Generated
    public void setMaxEntryTTL(Uint32 maxEntryTTL) {
        this.maxEntryTTL = maxEntryTTL;
    }

    @Generated
    public void setMinTemporaryTTL(Uint32 minTemporaryTTL) {
        this.minTemporaryTTL = minTemporaryTTL;
    }

    @Generated
    public void setMinPersistentTTL(Uint32 minPersistentTTL) {
        this.minPersistentTTL = minPersistentTTL;
    }

    @Generated
    public void setPersistentRentRateDenominator(Int64 persistentRentRateDenominator) {
        this.persistentRentRateDenominator = persistentRentRateDenominator;
    }

    @Generated
    public void setTempRentRateDenominator(Int64 tempRentRateDenominator) {
        this.tempRentRateDenominator = tempRentRateDenominator;
    }

    @Generated
    public void setMaxEntriesToArchive(Uint32 maxEntriesToArchive) {
        this.maxEntriesToArchive = maxEntriesToArchive;
    }

    @Generated
    public void setLiveSorobanStateSizeWindowSampleSize(Uint32 liveSorobanStateSizeWindowSampleSize) {
        this.liveSorobanStateSizeWindowSampleSize = liveSorobanStateSizeWindowSampleSize;
    }

    @Generated
    public void setLiveSorobanStateSizeWindowSamplePeriod(Uint32 liveSorobanStateSizeWindowSamplePeriod) {
        this.liveSorobanStateSizeWindowSamplePeriod = liveSorobanStateSizeWindowSamplePeriod;
    }

    @Generated
    public void setEvictionScanSize(Uint32 evictionScanSize) {
        this.evictionScanSize = evictionScanSize;
    }

    @Generated
    public void setStartingEvictionScanLevel(Uint32 startingEvictionScanLevel) {
        this.startingEvictionScanLevel = startingEvictionScanLevel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateArchivalSettings)) {
            return false;
        }
        StateArchivalSettings other = (StateArchivalSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$maxEntryTTL = this.getMaxEntryTTL();
        Uint32 other$maxEntryTTL = other.getMaxEntryTTL();
        if (this$maxEntryTTL == null ? other$maxEntryTTL != null : !((Object)this$maxEntryTTL).equals(other$maxEntryTTL)) {
            return false;
        }
        Uint32 this$minTemporaryTTL = this.getMinTemporaryTTL();
        Uint32 other$minTemporaryTTL = other.getMinTemporaryTTL();
        if (this$minTemporaryTTL == null ? other$minTemporaryTTL != null : !((Object)this$minTemporaryTTL).equals(other$minTemporaryTTL)) {
            return false;
        }
        Uint32 this$minPersistentTTL = this.getMinPersistentTTL();
        Uint32 other$minPersistentTTL = other.getMinPersistentTTL();
        if (this$minPersistentTTL == null ? other$minPersistentTTL != null : !((Object)this$minPersistentTTL).equals(other$minPersistentTTL)) {
            return false;
        }
        Int64 this$persistentRentRateDenominator = this.getPersistentRentRateDenominator();
        Int64 other$persistentRentRateDenominator = other.getPersistentRentRateDenominator();
        if (this$persistentRentRateDenominator == null ? other$persistentRentRateDenominator != null : !((Object)this$persistentRentRateDenominator).equals(other$persistentRentRateDenominator)) {
            return false;
        }
        Int64 this$tempRentRateDenominator = this.getTempRentRateDenominator();
        Int64 other$tempRentRateDenominator = other.getTempRentRateDenominator();
        if (this$tempRentRateDenominator == null ? other$tempRentRateDenominator != null : !((Object)this$tempRentRateDenominator).equals(other$tempRentRateDenominator)) {
            return false;
        }
        Uint32 this$maxEntriesToArchive = this.getMaxEntriesToArchive();
        Uint32 other$maxEntriesToArchive = other.getMaxEntriesToArchive();
        if (this$maxEntriesToArchive == null ? other$maxEntriesToArchive != null : !((Object)this$maxEntriesToArchive).equals(other$maxEntriesToArchive)) {
            return false;
        }
        Uint32 this$liveSorobanStateSizeWindowSampleSize = this.getLiveSorobanStateSizeWindowSampleSize();
        Uint32 other$liveSorobanStateSizeWindowSampleSize = other.getLiveSorobanStateSizeWindowSampleSize();
        if (this$liveSorobanStateSizeWindowSampleSize == null ? other$liveSorobanStateSizeWindowSampleSize != null : !((Object)this$liveSorobanStateSizeWindowSampleSize).equals(other$liveSorobanStateSizeWindowSampleSize)) {
            return false;
        }
        Uint32 this$liveSorobanStateSizeWindowSamplePeriod = this.getLiveSorobanStateSizeWindowSamplePeriod();
        Uint32 other$liveSorobanStateSizeWindowSamplePeriod = other.getLiveSorobanStateSizeWindowSamplePeriod();
        if (this$liveSorobanStateSizeWindowSamplePeriod == null ? other$liveSorobanStateSizeWindowSamplePeriod != null : !((Object)this$liveSorobanStateSizeWindowSamplePeriod).equals(other$liveSorobanStateSizeWindowSamplePeriod)) {
            return false;
        }
        Uint32 this$evictionScanSize = this.getEvictionScanSize();
        Uint32 other$evictionScanSize = other.getEvictionScanSize();
        if (this$evictionScanSize == null ? other$evictionScanSize != null : !((Object)this$evictionScanSize).equals(other$evictionScanSize)) {
            return false;
        }
        Uint32 this$startingEvictionScanLevel = this.getStartingEvictionScanLevel();
        Uint32 other$startingEvictionScanLevel = other.getStartingEvictionScanLevel();
        return !(this$startingEvictionScanLevel == null ? other$startingEvictionScanLevel != null : !((Object)this$startingEvictionScanLevel).equals(other$startingEvictionScanLevel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StateArchivalSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $maxEntryTTL = this.getMaxEntryTTL();
        result = result * 59 + ($maxEntryTTL == null ? 43 : ((Object)$maxEntryTTL).hashCode());
        Uint32 $minTemporaryTTL = this.getMinTemporaryTTL();
        result = result * 59 + ($minTemporaryTTL == null ? 43 : ((Object)$minTemporaryTTL).hashCode());
        Uint32 $minPersistentTTL = this.getMinPersistentTTL();
        result = result * 59 + ($minPersistentTTL == null ? 43 : ((Object)$minPersistentTTL).hashCode());
        Int64 $persistentRentRateDenominator = this.getPersistentRentRateDenominator();
        result = result * 59 + ($persistentRentRateDenominator == null ? 43 : ((Object)$persistentRentRateDenominator).hashCode());
        Int64 $tempRentRateDenominator = this.getTempRentRateDenominator();
        result = result * 59 + ($tempRentRateDenominator == null ? 43 : ((Object)$tempRentRateDenominator).hashCode());
        Uint32 $maxEntriesToArchive = this.getMaxEntriesToArchive();
        result = result * 59 + ($maxEntriesToArchive == null ? 43 : ((Object)$maxEntriesToArchive).hashCode());
        Uint32 $liveSorobanStateSizeWindowSampleSize = this.getLiveSorobanStateSizeWindowSampleSize();
        result = result * 59 + ($liveSorobanStateSizeWindowSampleSize == null ? 43 : ((Object)$liveSorobanStateSizeWindowSampleSize).hashCode());
        Uint32 $liveSorobanStateSizeWindowSamplePeriod = this.getLiveSorobanStateSizeWindowSamplePeriod();
        result = result * 59 + ($liveSorobanStateSizeWindowSamplePeriod == null ? 43 : ((Object)$liveSorobanStateSizeWindowSamplePeriod).hashCode());
        Uint32 $evictionScanSize = this.getEvictionScanSize();
        result = result * 59 + ($evictionScanSize == null ? 43 : ((Object)$evictionScanSize).hashCode());
        Uint32 $startingEvictionScanLevel = this.getStartingEvictionScanLevel();
        result = result * 59 + ($startingEvictionScanLevel == null ? 43 : ((Object)$startingEvictionScanLevel).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StateArchivalSettings(maxEntryTTL=" + this.getMaxEntryTTL() + ", minTemporaryTTL=" + this.getMinTemporaryTTL() + ", minPersistentTTL=" + this.getMinPersistentTTL() + ", persistentRentRateDenominator=" + this.getPersistentRentRateDenominator() + ", tempRentRateDenominator=" + this.getTempRentRateDenominator() + ", maxEntriesToArchive=" + this.getMaxEntriesToArchive() + ", liveSorobanStateSizeWindowSampleSize=" + this.getLiveSorobanStateSizeWindowSampleSize() + ", liveSorobanStateSizeWindowSamplePeriod=" + this.getLiveSorobanStateSizeWindowSamplePeriod() + ", evictionScanSize=" + this.getEvictionScanSize() + ", startingEvictionScanLevel=" + this.getStartingEvictionScanLevel() + ")";
    }

    @Generated
    public StateArchivalSettings() {
    }

    @Generated
    public StateArchivalSettings(Uint32 maxEntryTTL, Uint32 minTemporaryTTL, Uint32 minPersistentTTL, Int64 persistentRentRateDenominator, Int64 tempRentRateDenominator, Uint32 maxEntriesToArchive, Uint32 liveSorobanStateSizeWindowSampleSize, Uint32 liveSorobanStateSizeWindowSamplePeriod, Uint32 evictionScanSize, Uint32 startingEvictionScanLevel) {
        this.maxEntryTTL = maxEntryTTL;
        this.minTemporaryTTL = minTemporaryTTL;
        this.minPersistentTTL = minPersistentTTL;
        this.persistentRentRateDenominator = persistentRentRateDenominator;
        this.tempRentRateDenominator = tempRentRateDenominator;
        this.maxEntriesToArchive = maxEntriesToArchive;
        this.liveSorobanStateSizeWindowSampleSize = liveSorobanStateSizeWindowSampleSize;
        this.liveSorobanStateSizeWindowSamplePeriod = liveSorobanStateSizeWindowSamplePeriod;
        this.evictionScanSize = evictionScanSize;
        this.startingEvictionScanLevel = startingEvictionScanLevel;
    }

    @Generated
    public static class StateArchivalSettingsBuilder {
        @Generated
        private Uint32 maxEntryTTL;
        @Generated
        private Uint32 minTemporaryTTL;
        @Generated
        private Uint32 minPersistentTTL;
        @Generated
        private Int64 persistentRentRateDenominator;
        @Generated
        private Int64 tempRentRateDenominator;
        @Generated
        private Uint32 maxEntriesToArchive;
        @Generated
        private Uint32 liveSorobanStateSizeWindowSampleSize;
        @Generated
        private Uint32 liveSorobanStateSizeWindowSamplePeriod;
        @Generated
        private Uint32 evictionScanSize;
        @Generated
        private Uint32 startingEvictionScanLevel;

        @Generated
        StateArchivalSettingsBuilder() {
        }

        @Generated
        public StateArchivalSettingsBuilder maxEntryTTL(Uint32 maxEntryTTL) {
            this.maxEntryTTL = maxEntryTTL;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder minTemporaryTTL(Uint32 minTemporaryTTL) {
            this.minTemporaryTTL = minTemporaryTTL;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder minPersistentTTL(Uint32 minPersistentTTL) {
            this.minPersistentTTL = minPersistentTTL;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder persistentRentRateDenominator(Int64 persistentRentRateDenominator) {
            this.persistentRentRateDenominator = persistentRentRateDenominator;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder tempRentRateDenominator(Int64 tempRentRateDenominator) {
            this.tempRentRateDenominator = tempRentRateDenominator;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder maxEntriesToArchive(Uint32 maxEntriesToArchive) {
            this.maxEntriesToArchive = maxEntriesToArchive;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder liveSorobanStateSizeWindowSampleSize(Uint32 liveSorobanStateSizeWindowSampleSize) {
            this.liveSorobanStateSizeWindowSampleSize = liveSorobanStateSizeWindowSampleSize;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder liveSorobanStateSizeWindowSamplePeriod(Uint32 liveSorobanStateSizeWindowSamplePeriod) {
            this.liveSorobanStateSizeWindowSamplePeriod = liveSorobanStateSizeWindowSamplePeriod;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder evictionScanSize(Uint32 evictionScanSize) {
            this.evictionScanSize = evictionScanSize;
            return this;
        }

        @Generated
        public StateArchivalSettingsBuilder startingEvictionScanLevel(Uint32 startingEvictionScanLevel) {
            this.startingEvictionScanLevel = startingEvictionScanLevel;
            return this;
        }

        @Generated
        public StateArchivalSettings build() {
            return new StateArchivalSettings(this.maxEntryTTL, this.minTemporaryTTL, this.minPersistentTTL, this.persistentRentRateDenominator, this.tempRentRateDenominator, this.maxEntriesToArchive, this.liveSorobanStateSizeWindowSampleSize, this.liveSorobanStateSizeWindowSamplePeriod, this.evictionScanSize, this.startingEvictionScanLevel);
        }

        @Generated
        public String toString() {
            return "StateArchivalSettings.StateArchivalSettingsBuilder(maxEntryTTL=" + this.maxEntryTTL + ", minTemporaryTTL=" + this.minTemporaryTTL + ", minPersistentTTL=" + this.minPersistentTTL + ", persistentRentRateDenominator=" + this.persistentRentRateDenominator + ", tempRentRateDenominator=" + this.tempRentRateDenominator + ", maxEntriesToArchive=" + this.maxEntriesToArchive + ", liveSorobanStateSizeWindowSampleSize=" + this.liveSorobanStateSizeWindowSampleSize + ", liveSorobanStateSizeWindowSamplePeriod=" + this.liveSorobanStateSizeWindowSamplePeriod + ", evictionScanSize=" + this.evictionScanSize + ", startingEvictionScanLevel=" + this.startingEvictionScanLevel + ")";
        }
    }
}

