/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.SorobanTransactionMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMetaV3
implements XdrElement {
    private ExtensionPoint ext;
    private LedgerEntryChanges txChangesBefore;
    private OperationMeta[] operations;
    private LedgerEntryChanges txChangesAfter;
    private SorobanTransactionMeta sorobanMeta;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.txChangesBefore.encode(stream);
        int operationsSize = this.getOperations().length;
        stream.writeInt(operationsSize);
        for (int i = 0; i < operationsSize; ++i) {
            this.operations[i].encode(stream);
        }
        this.txChangesAfter.encode(stream);
        if (this.sorobanMeta != null) {
            stream.writeInt(1);
            this.sorobanMeta.encode(stream);
        } else {
            stream.writeInt(0);
        }
    }

    public static TransactionMetaV3 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV3 decodedTransactionMetaV3 = new TransactionMetaV3();
        decodedTransactionMetaV3.ext = ExtensionPoint.decode(stream);
        decodedTransactionMetaV3.txChangesBefore = LedgerEntryChanges.decode(stream);
        int operationsSize = stream.readInt();
        decodedTransactionMetaV3.operations = new OperationMeta[operationsSize];
        for (int i = 0; i < operationsSize; ++i) {
            decodedTransactionMetaV3.operations[i] = OperationMeta.decode(stream);
        }
        decodedTransactionMetaV3.txChangesAfter = LedgerEntryChanges.decode(stream);
        int sorobanMetaPresent = stream.readInt();
        if (sorobanMetaPresent != 0) {
            decodedTransactionMetaV3.sorobanMeta = SorobanTransactionMeta.decode(stream);
        }
        return decodedTransactionMetaV3;
    }

    public static TransactionMetaV3 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMetaV3.fromXdrByteArray(bytes);
    }

    public static TransactionMetaV3 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMetaV3.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionMetaV3Builder builder() {
        return new TransactionMetaV3Builder();
    }

    @Generated
    public TransactionMetaV3Builder toBuilder() {
        return new TransactionMetaV3Builder().ext(this.ext).txChangesBefore(this.txChangesBefore).operations(this.operations).txChangesAfter(this.txChangesAfter).sorobanMeta(this.sorobanMeta);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public LedgerEntryChanges getTxChangesBefore() {
        return this.txChangesBefore;
    }

    @Generated
    public OperationMeta[] getOperations() {
        return this.operations;
    }

    @Generated
    public LedgerEntryChanges getTxChangesAfter() {
        return this.txChangesAfter;
    }

    @Generated
    public SorobanTransactionMeta getSorobanMeta() {
        return this.sorobanMeta;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setTxChangesBefore(LedgerEntryChanges txChangesBefore) {
        this.txChangesBefore = txChangesBefore;
    }

    @Generated
    public void setOperations(OperationMeta[] operations) {
        this.operations = operations;
    }

    @Generated
    public void setTxChangesAfter(LedgerEntryChanges txChangesAfter) {
        this.txChangesAfter = txChangesAfter;
    }

    @Generated
    public void setSorobanMeta(SorobanTransactionMeta sorobanMeta) {
        this.sorobanMeta = sorobanMeta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMetaV3)) {
            return false;
        }
        TransactionMetaV3 other = (TransactionMetaV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        LedgerEntryChanges this$txChangesBefore = this.getTxChangesBefore();
        LedgerEntryChanges other$txChangesBefore = other.getTxChangesBefore();
        if (this$txChangesBefore == null ? other$txChangesBefore != null : !((Object)this$txChangesBefore).equals(other$txChangesBefore)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        LedgerEntryChanges this$txChangesAfter = this.getTxChangesAfter();
        LedgerEntryChanges other$txChangesAfter = other.getTxChangesAfter();
        if (this$txChangesAfter == null ? other$txChangesAfter != null : !((Object)this$txChangesAfter).equals(other$txChangesAfter)) {
            return false;
        }
        SorobanTransactionMeta this$sorobanMeta = this.getSorobanMeta();
        SorobanTransactionMeta other$sorobanMeta = other.getSorobanMeta();
        return !(this$sorobanMeta == null ? other$sorobanMeta != null : !((Object)this$sorobanMeta).equals(other$sorobanMeta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionMetaV3;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        LedgerEntryChanges $txChangesBefore = this.getTxChangesBefore();
        result = result * 59 + ($txChangesBefore == null ? 43 : ((Object)$txChangesBefore).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        LedgerEntryChanges $txChangesAfter = this.getTxChangesAfter();
        result = result * 59 + ($txChangesAfter == null ? 43 : ((Object)$txChangesAfter).hashCode());
        SorobanTransactionMeta $sorobanMeta = this.getSorobanMeta();
        result = result * 59 + ($sorobanMeta == null ? 43 : ((Object)$sorobanMeta).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionMetaV3(ext=" + this.getExt() + ", txChangesBefore=" + this.getTxChangesBefore() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", txChangesAfter=" + this.getTxChangesAfter() + ", sorobanMeta=" + this.getSorobanMeta() + ")";
    }

    @Generated
    public TransactionMetaV3() {
    }

    @Generated
    public TransactionMetaV3(ExtensionPoint ext, LedgerEntryChanges txChangesBefore, OperationMeta[] operations, LedgerEntryChanges txChangesAfter, SorobanTransactionMeta sorobanMeta) {
        this.ext = ext;
        this.txChangesBefore = txChangesBefore;
        this.operations = operations;
        this.txChangesAfter = txChangesAfter;
        this.sorobanMeta = sorobanMeta;
    }

    @Generated
    public static class TransactionMetaV3Builder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private LedgerEntryChanges txChangesBefore;
        @Generated
        private OperationMeta[] operations;
        @Generated
        private LedgerEntryChanges txChangesAfter;
        @Generated
        private SorobanTransactionMeta sorobanMeta;

        @Generated
        TransactionMetaV3Builder() {
        }

        @Generated
        public TransactionMetaV3Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TransactionMetaV3Builder txChangesBefore(LedgerEntryChanges txChangesBefore) {
            this.txChangesBefore = txChangesBefore;
            return this;
        }

        @Generated
        public TransactionMetaV3Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionMetaV3Builder txChangesAfter(LedgerEntryChanges txChangesAfter) {
            this.txChangesAfter = txChangesAfter;
            return this;
        }

        @Generated
        public TransactionMetaV3Builder sorobanMeta(SorobanTransactionMeta sorobanMeta) {
            this.sorobanMeta = sorobanMeta;
            return this;
        }

        @Generated
        public TransactionMetaV3 build() {
            return new TransactionMetaV3(this.ext, this.txChangesBefore, this.operations, this.txChangesAfter, this.sorobanMeta);
        }

        @Generated
        public String toString() {
            return "TransactionMetaV3.TransactionMetaV3Builder(ext=" + this.ext + ", txChangesBefore=" + this.txChangesBefore + ", operations=" + Arrays.deepToString(this.operations) + ", txChangesAfter=" + this.txChangesAfter + ", sorobanMeta=" + this.sorobanMeta + ")";
        }
    }
}

