/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ParallelTxsComponent;
import org.stellar.sdk.xdr.TxSetComponent;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionPhase
implements XdrElement {
    private Integer discriminant;
    private TxSetComponent[] v0Components;
    private ParallelTxsComponent parallelTxsComponent;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant);
        switch (this.discriminant) {
            case 0: {
                int v0ComponentsSize = this.getV0Components().length;
                stream.writeInt(v0ComponentsSize);
                for (int i = 0; i < v0ComponentsSize; ++i) {
                    this.v0Components[i].encode(stream);
                }
                break;
            }
            case 1: {
                this.parallelTxsComponent.encode(stream);
            }
        }
    }

    public static TransactionPhase decode(XdrDataInputStream stream) throws IOException {
        TransactionPhase decodedTransactionPhase = new TransactionPhase();
        Integer discriminant = stream.readInt();
        decodedTransactionPhase.setDiscriminant(discriminant);
        switch (decodedTransactionPhase.getDiscriminant()) {
            case 0: {
                int v0ComponentsSize = stream.readInt();
                decodedTransactionPhase.v0Components = new TxSetComponent[v0ComponentsSize];
                for (int i = 0; i < v0ComponentsSize; ++i) {
                    decodedTransactionPhase.v0Components[i] = TxSetComponent.decode(stream);
                }
                break;
            }
            case 1: {
                decodedTransactionPhase.parallelTxsComponent = ParallelTxsComponent.decode(stream);
            }
        }
        return decodedTransactionPhase;
    }

    public static TransactionPhase fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionPhase.fromXdrByteArray(bytes);
    }

    public static TransactionPhase fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionPhase.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionPhaseBuilder builder() {
        return new TransactionPhaseBuilder();
    }

    @Generated
    public TransactionPhaseBuilder toBuilder() {
        return new TransactionPhaseBuilder().discriminant(this.discriminant).v0Components(this.v0Components).parallelTxsComponent(this.parallelTxsComponent);
    }

    @Generated
    public Integer getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public TxSetComponent[] getV0Components() {
        return this.v0Components;
    }

    @Generated
    public ParallelTxsComponent getParallelTxsComponent() {
        return this.parallelTxsComponent;
    }

    @Generated
    public void setDiscriminant(Integer discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0Components(TxSetComponent[] v0Components) {
        this.v0Components = v0Components;
    }

    @Generated
    public void setParallelTxsComponent(ParallelTxsComponent parallelTxsComponent) {
        this.parallelTxsComponent = parallelTxsComponent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionPhase)) {
            return false;
        }
        TransactionPhase other = (TransactionPhase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$discriminant = this.getDiscriminant();
        Integer other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getV0Components(), other.getV0Components())) {
            return false;
        }
        ParallelTxsComponent this$parallelTxsComponent = this.getParallelTxsComponent();
        ParallelTxsComponent other$parallelTxsComponent = other.getParallelTxsComponent();
        return !(this$parallelTxsComponent == null ? other$parallelTxsComponent != null : !((Object)this$parallelTxsComponent).equals(other$parallelTxsComponent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionPhase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getV0Components());
        ParallelTxsComponent $parallelTxsComponent = this.getParallelTxsComponent();
        result = result * 59 + ($parallelTxsComponent == null ? 43 : ((Object)$parallelTxsComponent).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionPhase(discriminant=" + this.getDiscriminant() + ", v0Components=" + Arrays.deepToString(this.getV0Components()) + ", parallelTxsComponent=" + this.getParallelTxsComponent() + ")";
    }

    @Generated
    public TransactionPhase() {
    }

    @Generated
    public TransactionPhase(Integer discriminant, TxSetComponent[] v0Components, ParallelTxsComponent parallelTxsComponent) {
        this.discriminant = discriminant;
        this.v0Components = v0Components;
        this.parallelTxsComponent = parallelTxsComponent;
    }

    @Generated
    public static class TransactionPhaseBuilder {
        @Generated
        private Integer discriminant;
        @Generated
        private TxSetComponent[] v0Components;
        @Generated
        private ParallelTxsComponent parallelTxsComponent;

        @Generated
        TransactionPhaseBuilder() {
        }

        @Generated
        public TransactionPhaseBuilder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public TransactionPhaseBuilder v0Components(TxSetComponent[] v0Components) {
            this.v0Components = v0Components;
            return this;
        }

        @Generated
        public TransactionPhaseBuilder parallelTxsComponent(ParallelTxsComponent parallelTxsComponent) {
            this.parallelTxsComponent = parallelTxsComponent;
            return this;
        }

        @Generated
        public TransactionPhase build() {
            return new TransactionPhase(this.discriminant, this.v0Components, this.parallelTxsComponent);
        }

        @Generated
        public String toString() {
            return "TransactionPhase.TransactionPhaseBuilder(discriminant=" + this.discriminant + ", v0Components=" + Arrays.deepToString(this.v0Components) + ", parallelTxsComponent=" + this.parallelTxsComponent + ")";
        }
    }
}

